const Helper = require('@open-xchange/codecept-helper').helper;

class GuardHelper extends Helper {

    async verifyUserSetup (user) {
        const { page } = this.helpers['Puppeteer'];

        assert(user && user.password, 'user or user password not configured');  //Check user exists

        var result = await page.evaluate(function (user, done) {
            if (window.oxguarddata.passcode === null) {  // already setup
                return(true);
                return;
            }
            if (window.oxguarddata.passcode === 'No Key') { // Needs setup
                var def = $.Deferred();
                require (['oxguard/core/og_http'], function (og_http) {
                    var json = {
                            name: user.name,
                            password: user.password
                        };
                    try {
                        og_http.simplePost(ox.apiRoot + '/oxguard/keys?action=create', '', json)
                        .done(function (data) {
                            if (data.error) done(data.error_desc);
                            if (data.data) {
                                window.oxguarddata.passcode = null;
                                def.resolve(true);
                            } else {
                                def.resolve('Failed to get login data');
                            }
                        })
                        .fail(function (e) {
                            def.resolve('fail post');
                        });
                    } catch (e) {
                        def.resolve(e.message);
                    }
                });
                return def;
            } else {
                return('fail');  // temporary password or lockout
            }
        }, user);

        assert(result === true, result);
    }

    insertPassword(selector, user) {
        if (!user.password) this.assert.fail('user without password', 'A configured password for user at index ' + userIndex, 'Expected a user with password when calling insertPassword.');
        this.clearValue(selector);
        this.setValue(selector, user.password);
    
        return this;
    }

    async downloadPrivateKey(keyId, userdata) {
        const { page } = this.helpers['Puppeteer'];
        return new Promise(function(resolve, reject) {
            page.evaluate(function (userdata, id) {
                var def = $.Deferred();
                var params = '&keyid=' + (_.isArray(id) ? id[0] : id) +
                '&keyType=private' +
                '&session=' + ox.session;
                var data = {
                    password: userdata.password
                };
                var link = ox.apiRoot + '/oxguard/keys?action=downloadKey';
                require(['oxguard/core/og_http'], function (og_http) {
                    og_http.simplePost(link, params, data).then(function (data) {
                        def.resolve(data);
                    }, def.reject);
                });
                return def;
            }, userdata, keyId).then(resolve, reject);
        });
    }

    async addToTextDocument(textToAdd) {
        const { page } = this.helpers['Puppeteer'];
        page.keyboard.type(textToAdd);
    }

    async selectEmailNumber(num) {
        const { page } = this.helpers['Puppeteer'];
        var selector = 'ul.list-view li:nth-child(' + (num + 1) + ')';
        await page.$eval(selector, el => { el.click(); });
    }

    async openThreadEmail(num) {
        const { page } = this.helpers['Puppeteer'];
        return new Promise(function(resolve, reject) {
            page.evaluate(function (num) {
                var selector = '.multiple-messages article:nth-of-type(' + num +')';
                var def = $.Deferred();
                var attempts = 0;
                function isOpen() {
                    return $(selector + ' .content').is(':visible') || $(selector + ' .body').is(':visible');
                }
                function tryOpen(attempts) {
                    console.log('attempting' + attempts);
                    console.log(selector);
                    console.log(selector + ' .toggle-mail-body');
                    $(selector + ' .toggle-mail-body').click();
                    setTimeout(function() {
                        if (isOpen()) {
                            def.resolve();
                            return;
                        }
                        if (!isOpen() && attempts++ < 2) {
                            tryOpen(attempts);
                        }
                        if (attempts > 2) {
                            def.reject();
                        }
                    }, 500);
                }
                if (isOpen()) {
                    def.resolve();
                } else {
                    tryOpen(0);
                }
                return def;
            }, num).then(resolve, reject);
        });
    }
}
module.exports = GuardHelper;