/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Greg Hill <greg.hill@open-xchange.com>
 */

define('oxguard/settings/views/privateDetailView', [
    'io.ox/backbone/views',
    'io.ox/core/extensions',
    'io.ox/backbone/views/modal',
    'io.ox/core/settings/util',
    'io.ox/core/yell',
    'oxguard/oxguard_core',
    'gettext!oxguard',
    'less!oxguard/settings/style',
    'less!oxguard/pgp/style'
], function (views, ext, ModalView, util, yell, core, gt) {

    'use strict';

    var POINT = 'oxguard/settings/privateDetailView',
        INDEX = 0;

    function open(table, keyData, guard) {
        return openModalDialog(table, keyData, guard);
    }

    function openModalDialog(keyData) {

        return new ModalView({
            async: true,
            point: POINT,
            title: gt('Key Details'),
            id: 'privKeyDetail',
            width: 640,
            model: new Backbone.Model({ 'data': keyData })
        })
        .inject({
            showSignatures: function () {
                // Pull list of signatures
                var keyId = this.model.get('data').id;
                ox.load(['oxguard/pgp/signatureView']).done(function (view) {
                    view.open(keyId);
                });
            }
        })
        .addAlternativeButton({ label: gt('Signatures'), action: 'signatures' })
        .addButton({ label: gt('Done'), action: 'done' })
        .on('done', function () {
            this.close();
        })
        .on('signatures', function () {
            this.showSignatures();
            this.idle();
        })
        .open();
    }

    ext.point(POINT).extend(
        // Draw Div with key details
        {
            index: INDEX += 100,
            id: 'detail',
            render: function (baton) {
                var div = $('<div>');
                this.$body.append(
                    div.append(getDetailDiv(baton.model.get('data')))
                );
            }
        }
    );

    function getDetailDiv(data) {
        var resultdiv = $('<div>');
        if (data.revoked) { resultdiv.append('<span style="color:red;">' + gt('Revoked') + '</span><br>'); }

        resultdiv.append(gt('Key ID:') + ' ' + formatKeyID(data.fingerPrint) + '<br><br>');
        var detaildiv = $('<div style="padding-left:20px;">');
        detaildiv.append(gt('Fingerprint:') + ' ' + data.fingerPrint + '<br>');
        var created = new Date(data.creationTime);
        if (data.expired === true) {
            detaildiv.append(gt('Expired') + '<br>');
            detaildiv.css('color', 'red');
        } else if (data.validSeconds !== 0) {
            var expires = new Date(created.getTime() + (data.validSeconds * 1000));
            detaildiv.append(gt('Expires:') + ' ' + expires.toDateString() + '<br>');
        }

        detaildiv.append(gt('Private Key: ') + (data.hasPrivateKey ? gt('True') : gt('False')) + '<br>');
        detaildiv.append(gt('Created:') + ' ' + created.toLocaleDateString() + '<br>');
        detaildiv.append(gt('Master:') + ' ' + (data.masterKey ? gt('True') : gt('False')) + '<br>');
        detaildiv.append(gt('Encryption:') + ' ' + (data.encryptionKey ? gt('True') : gt('False')) + '<br>');
        var ids = '';
        for (var j = 0; j < data.userIds.length; j++) {
            if (j > 0) ids = ids + ', ';
            ids = ids + core.htmlSafe(data.userIds[j]);
        }
        detaildiv.append(gt('IDs: ') + ids + '<br>');
        resultdiv.append(detaildiv);
        return (resultdiv);
    }

    function formatKeyID(id) {
        if (id.length < 9) return (id);
        return ('<span class="keystart">' + id.substring(0, (id.length - 8)) + '</span><span class="keyend">' + id.substring((id.length - 8)) + '</span>');
    }

    return {
        open: open
    };

});
