/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016-2020 OX Software GmbH
 */

define('oxguard/settings', [
    'io.ox/core/extensions',
    'oxguard/util',
    'io.ox/core/capabilities'
], function (ext, util, capabilities) {

    'use strict';

    if (util.isGuardConfigured() || capabilities.has('guard-mail') || capabilities.has('guard-drive')) {
        // Add settings for encryption to the Settings Page
        ext.point('io.ox/settings/pane/general/security').extend({
            id: 'oxguard',
            //#. %s product Name
            title: window.oxguarddata.productName,
            index: 600,
            loadSettingPane: true
        });

        ext.point('io.ox/settings/help/mapping').extend({
            id: 'guardHelp',
            index: 200,
            list: function () {
                _.extend(this, {
                    'virtual/settings/oxguard': {
                        base: 'help',
                        target: 'ox.appsuite.user.sect.guard.settings.html'
                    }
                });
            }
        });

    }

    if (!util.isGuardLoaded()) {
        var removeIfNotNeeded = function () {
            if (!util.isGuardConfigured() && !(capabilities.has('guard-mail') || capabilities.has('guard-drive'))) {
                $('[data-model="virtual/settings/oxguard"]').remove();
            }
        };
        util.addOnLoaded(removeIfNotNeeded);
    }

});
