/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Greg Hill <greg.hill@open-xchange.com>
 */

define('oxguard/core/passwordPrompt', [
    'io.ox/core/extensions',
    'io.ox/backbone/views/modal',
    'oxguard/core/passwordView',
    'settings!oxguard',
    'gettext!oxguard',
    'less!oxguard/core/style'
], function (ext, ModalView, PasswordView, guardSettings, gt) {

    'use strict';

    /// Authentication Section

    ext.point('oxguard_core/auth').extend({
        id: 'renderAuth',
        index: 100,
        render: function (baton) {
            //#. %s product name
            var help =  $('<label for="ogPassword">' + gt('Please enter your %s password', window.oxguarddata.productName) + '</label>');
            var message = baton.model.get('message');
            if (message !== undefined && message.length > 1) {
                help = $('<label for="ogPassword">' + message + '</label>');
            }
            var passwordBoxView = new PasswordView.view({ 'id': 'ogPassword', 'class': 'password_prompt popup_password_prompt', 'validate': false });
            var pass = passwordBoxView.getProtected().css('display', 'inline');
            this.$body.append(help).append(pass);
            if (baton.model.get('timeOption')) {
                var remembertext = $('<label class="checkbox custom small" for="rememberpass" style="font-weight:normal">' + gt('Remember my password') + '</label>');
                var checkbox = $('<input type="checkbox" name="rememberpass" id="rememberpass" value="true"/>');
                var rememberpass = $('<div>').append(remembertext.append(checkbox));
                //#. Duration that password should be remembered
                var durationLabel = $('<label for="duration" style="font-weight:normal">' + gt('Duration:') + '</label>');
                var duration = $('<select id="duration" class="og_duration"><option value="10">' + gt('10 minutes') + '</option>' +
                        '<option value="20">' + gt('20 minutes') + '</option>' +
                        '<option value="30">' + gt('30 minutes') + '</option>' +
                        '<option value="60">' + gt('1 hour') + '</option>' +
                        '<option value="120">' + gt('2 hours') + '</option>' +
                        '<option value="99999">' + gt('Session') + '</option>' +
                        '</select>')
                        .on('change', function () {
                            $('input[name="rememberpass"]').prop('checked', true);
                        });
                rememberpass.append(durationLabel.append(duration));
                if (guardSettings.get('defRemember')) {
                    duration.val(guardSettings.get('defRemember') === '0' ? 99999 : guardSettings.get('defRemember'));
                    if (guardSettings.get('defRemember') !== '0') checkbox.prop('checked', true);
                }
                this.$body.append(rememberpass);

                if (window.oxguarddata.recoveryAvail) {  // Display password help if available
                    var forgotDiv = $('<div class="og_forgot">');
                    var forgotLink = $('<a href="#">').append(gt('Forgot Password'));
                    var dialog = this;
                    forgotLink.click(function (e) {
                        e.preventDefault();
                        dialog.close();
                        var options = { id: 'oxguard' };
                        ox.launch('io.ox/settings/main', options).done(function () {
                            this.setSettingsPane(options);
                        });
                        if (baton.model.get('def')) {
                            baton.model.get('def').reject();
                        }
                    });
                    this.$body.append(forgotDiv.append(forgotLink));
                }
            }
        }
    });

    // Password prompt
    function getpassword(message, timeOption, o) {
        var def = $.Deferred();
        if ($('.popup_password_prompt').length > 0) {
            def.reject('duplicate');
            return def;  // Max one password prompt box open
        }
        var dialog = new ModalView({
            async: true,
            point: 'oxguard_core/auth',
            title: gt('Password needed'),
            width: 350,
            focus: '#ogPassword',
            model: new Backbone.Model({ 'message': message, 'timeOption': timeOption, def: def })
        })
        .build(function () {
        })
        .addButton({ label: 'OK', action: 'ok' })
        .addCloseButton()
        .on('cancel', function () {
            def.reject('cancel');
        })
        .on('ok', function () {
            go(def, o);
            this.close();
        });
        // Custom action for enter here.  Focus the enter button, then allow keypress to continue
        // Allows onclick function for the button, allowing popups
        dialog.$el.on('keydown', function (e) {
            if (e.which !== 13) return;
            if (!$(e.target).is('input:text, input:password')) return;
            $('.modal-footer [data-action="ok"]').focus();
        });
        dialog.open();
        return (def);
    }

    function go(def, o) {
        var duration = -1;
        if ($('input[name="rememberpass"]').is(':checked')) {
            duration = $('#duration').val();
        }
        var data = {
            password: $('#ogPassword').val(),
            duration: duration
        };
        if (o && _.isFunction(o.preAuthCallback)) {
            o.preAuthCallback();
        }
        def.resolve(data);
    }

    function open(message, timeOption, o) {
        return getpassword(message, timeOption, o);
    }

    return {
        open: open
    };

});
