/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.guard.milter.actions.encryptor;

import org.slf4j.Logger;
import com.openexchange.exception.OXException;
import com.openexchange.guard.keymanagement.commons.RecipKey;
import com.openexchange.guard.keymanagement.services.RecipKeyService;
import com.openexchange.guard.keymanagement.services.impl.lookup.CompositeRecipKeyLookupStrategy;
import com.openexchange.guard.keymanagement.services.impl.lookup.GuardRecipKeyLookupStrategy;
import com.openexchange.guard.keymanagement.services.lookup.RecipKeyLookupStrategy;
import com.openexchange.guard.milter.actions.MilterRcptAction;
import com.openexchange.guard.milter.osgi.Services;
import com.openexchange.guard.milter.service.MilterMail;

/**
 * {@link MilterRcptActionEncryptor}
 *
 * @author <a href="mailto:greg.hill@open-xchange.com">Greg Hill</a>
 * @since v2.8.0
 */
public class MilterRcptActionEncryptor implements MilterRcptAction {

    private static Logger Log = org.slf4j.LoggerFactory.getLogger(MilterRcptActionEncryptor.class);
    /* (non-Javadoc)
     * @see com.openexchange.guard.milter.actions.MilterRcptAction#handleRcpt(com.openexchange.guard.milter.service.MilterMail, java.lang.String)
     */
    @Override
    public boolean handleRcpt(MilterMail mail, String rcp) throws OXException {
        RecipKeyService recipKeyService = Services.getService(RecipKeyService.class);
        RecipKey key = recipKeyService.getRecipKey(new CompositeRecipKeyLookupStrategy(new RecipKeyLookupStrategy[] {
            new GuardRecipKeyLookupStrategy()
        }), getEmail(rcp), 0, 0);
        if (key == null || !key.getEncryptIncoming()) {  // If no key or encryption not enabled then end
            mail.setHandle(false);
            return false;
        }
        Log.debug("Incoming email encryption set for " + rcp);
        mail.addRecipientKey(key);
        return true;
    }

    private String getEmail (String rcp) {
        if (rcp != null) {
            rcp = rcp.replaceAll("<", "").replaceAll(">", "");
        }
        return rcp;
    }


}
