/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * © 2017 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Greg Hill <greg.hill@open-xchange.com>
 */

/**
 * This deletes file if present from file list
 */
exports.command = function (filename) {

    this.executeAsync(function (filename, done) {
        var file = $('div.filename:contains("' + filename + '")');
        if (file.length === 0) {
            done(true);
            return;
        }
        file.click();
        setTimeout(function () {
            $('a.io-ox-action-link[data-action="delete"]').click();
            setTimeout(function () {
                if ($('.btn-primary[data-action="delete"]').length === 0) {
                    done(false);
                    return;
                }
                $('.btn-primary[data-action="delete"]').click();
                done('deleted');
            }, 500);
        }, 500);
    }, [filename], function (result) {
        if (!result.value) this.assert.fail('Failed to delete file');
        if (result.value === 'deleted') this.pause(1000); // pause for refresh
    });

}