/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * © 2017 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Greg Hill <greg.hill@open-xchange.com>
 */

/// <reference path="../../steps.d.ts" />

Feature('Attachments test');

const fs = require('fs');

Before(async function (users) {
    await users.create();
    await users.create();
    
});

After(async function (users) {
    await users.removeAll();
});

async function sendToSelf(I, userdata, att) {
    var random = Math.floor((Math.random() * 100000));
    var subject = "Test Subject " + random;
    var data = "Test data " + random;

    // Mark inbox as all read
    I.selectFolder('Inbox');
    I.waitForVisible('.selected .contextmenu-control');
    I.click('.selected .contextmenu-control');
    I.waitForVisible('.dropdown.open a[data-action="markfolderread"]');
    I.click('.dropdown.open a[data-action="markfolderread"]');

    // Open compose
    I.sendEmail(userdata, subject, data, att);

    I.waitForVisible('.io-ox-mail-window .leftside');
    I.click('#io-ox-refresh-icon');
    I.waitForVisible('.io-ox-mail-window .leftside ul li.unread');
    I.click('.io-ox-mail-window .leftside ul li.unread');
    I.waitForVisible('.io-ox-mail-window .mail-detail-pane .subject');
    I.see(subject);

    // Decrypt
    I.waitForElement('.btn.oxguard_passbutton');
    I.waitForElement('input.form-control.password_prompt');
    I.insertCryptPassword('input.form-control.password_prompt', userdata);
    I.click('.btn.oxguard_passbutton');

    I.verifyDecryptedMail(subject, data);

}

Scenario('View attachment', async function (I, users) {

    const o = {
        user: users[1]
    };
    const userdata = o.user.userdata;

    await I.setupUser(o, true);
    
    // Log in as User 0
    I.login('app=io.ox/mail', o);
    I.waitForVisible('.io-ox-mail-window .window-body');

    I.verifyUserSetup(userdata);  // Verify user has Guard setup

    await sendToSelf(I, userdata, 'e2e/testFiles/ox.png');

    // Verify Attachment
    I.waitForVisible('.inline-toolbar [data-action="io.ox/mail/attachment/actions/view"]');
    I.click('.inline-toolbar [data-action="io.ox/mail/attachment/actions/view"]');

    // Verify password prompt
    I.auth(userdata);

    // Verify attachment viewable
    I.waitForVisible('.swiper-slide-active .viewer-displayer-item.viewer-displayer-image');

    // Close it
    I.click('.classic-toolbar [data-action="io.ox/core/viewer/actions/toolbar/close"]');
    I.waitForVisible('.io-ox-mail-window .leftside');

    // OK, done
    I.logout();

});

Scenario('Save attachment', async function (I, users) {

    const o = {
        user: users[0]
    };
    const userdata = o.user.userdata;

    await I.setupUser(o, true);
    
    // Log in as User 0
    I.login('app=io.ox/mail', o);
    I.waitForVisible('.io-ox-mail-window .window-body');

    I.verifyUserSetup(userdata);  // Verify user has Guard setup

    await sendToSelf(I, userdata, 'e2e/testFiles/ox.png');

    // Verify Attachment
    I.waitForVisible('.inline-toolbar [data-action="io.ox/mail/attachment/actions/save"]');
    I.click('.inline-toolbar [data-action="io.ox/mail/attachment/actions/save"]');

    // Verify password prompt
    I.auth(userdata);

    // Verify attachment viewable
    I.waitForVisible('.folder-picker-dialog');
    I.waitForVisible('.folder.selectable.open.selected');

    // Close it
    I.click('Save');
    I.waitForInvisible('.io-ox-alert.io-ox-alert-busy');
    I.wait(1);
    I.see('Attachment has been saved');

    // Verify there and can be opened
    I.openApp('Drive');
    I.waitForVisible('ul.file-list-view.complete');
    I.see('ox.png', '.filename');

    I.doubleClick('.file-type-image .list-item-content');

    // Verify attachment viewable
    I.waitForVisible('.swiper-slide-active .viewer-displayer-item.viewer-displayer-image');

    I.see('ox.png', '.file-name');

    // Close it
    I.click('.classic-toolbar [data-action="io.ox/core/viewer/actions/toolbar/close"]');
    I.waitForVisible('ul.file-list-view.complete');

    // OK, done
    I.logout();

});

Scenario('Office: View then edit docx file attachment', async function (I, users) {

    const o = {
        user: users[0]
    };
    const userdata = o.user.userdata;

    await I.setupUser(o, true);
    
    // Log in as User 0
    I.login('app=io.ox/mail', o);
    I.waitForVisible('.io-ox-mail-window .window-body');

    I.verifyUserSetup(userdata);  // Verify user has Guard setup

    await sendToSelf(I, userdata, 'e2e/testFiles/Test.docx');

    // Verify Attachment
    I.waitForVisible('.inline-toolbar [data-action="io.ox/mail/attachment/actions/view"]');
    I.click('.inline-toolbar [data-action="io.ox/mail/attachment/actions/view"]');

    // Verify password prompt
    I.auth(userdata);

    I.waitForVisible('.document-container.io-ox-core-pdf');
    I.waitForText('Test', 3, '.text-wrapper');

    // Close it
    I.click('.classic-toolbar [data-action="io.ox/core/viewer/actions/toolbar/close"]');
    I.waitForVisible('.io-ox-mail-window .leftside');


    // Verify Attachment
    I.waitForVisible('.inline-toolbar [data-action="io.ox/mail/office/text-edit-asnew"]');
    I.click('.inline-toolbar [data-action="io.ox/mail/office/text-edit-asnew"]');

    // Verify password prompt
    I.auth(userdata);

    I.wait(2);

    I.switchToNextTab();
    I.waitForVisible('.button[data-value="format"]', 60);
    I.waitForVisible('.page.formatted-content.user-select-text', 20);
    I.see('Test', '.pagecontent');

    I.closeCurrentTab();
    I.wait(1);

    // OK, done
    I.logout();

});