/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016-2020 OX Software GmbH
 * Author Greg Hill <greg.hill@open-xchange.com>
 */

define('pgp_local/sessionHandler', [
    'oxguard/core/og_http'
], function (http) {

    'use strict';

    var handler = {
        getSessions: function (folder, id, module) {
            var def = $.Deferred();
            var data = {
                folder: folder,
                id: id,
                module: module
            };
            http.post(ox.apiRoot + '/guard-json?action=extractsessionkeys', '', data)
            .done(function (response) {
                if (response && response.data && response.data.encryptedSessionKeyPackets) {
                    def.resolve(response);
                } else {
                    def.reject(response);
                }
            })
            .fail(function (e) {
                console.log(e);
                def.reject(e);
            });
            return def;
        },
        saveDecryptedSession: function (decrypted) {
            var def = $.Deferred();
            var data = {
                pgp_session_key: decrypted,
                minutesValid: -1
            };
            http.post(ox.apiRoot + '/guard-json?action=auth-token', '', data)
            .done(function (data) {
                def.resolve(data);
            })
            .fail(function (e) {
                def.reject(e);
            });
            return def;
        }
    };

    return handler;

});
