/* All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016-2020 OX Software GmbH
 */

define('oxguard/mail/maillist', [
    'io.ox/mail/common-extensions',
    'io.ox/mail/api',
    'io.ox/core/extensions'
], function (extensions, mailApi, ext) {

    'use strict';

    var initialized = false;

    // Override default icon extension for encrypted icons
    extensions.pgp.encrypted = function (baton) {
        if (!/^multipart\/encrypted/.test(baton.data.content_type) &&
                !(baton.model.get('security_info') && baton.model.get('security_info').encrypted) &&
                !(baton.model.get('security') && baton.model.get('security').decrypted)) return;
        baton.data.text_preview = '';  // wipe the preview
        this.append(
            $('<i class="fa fa-lock encrypted" aria-hidden="true">')
        );
    };

    extensions.pgp.signed = function (baton) {
        //simple check for signed mail
        if (!/^multipart\/signed/.test(baton.data.content_type) &&
            !(baton.data.security && baton.data.security.signatures)) return;

        this.append(
            $('<i class="fa fa-pencil-square-o signed" aria-hidden="true">')
        );
    };

    // Changed selection.  Null out the guard current data
    function change() {
        window.oxguarddata.current = null;
    }

    // To initialize listview.  Setup here
    function listViewInit() {
        require(['io.ox/mail/main'], function (main) {
            var app = main.getApp();
            if (app.listView !== undefined) {
                app.listView.on('selection:change', change);
            }
        });
    }

    // Disable default paper clip, as all oxguard emails have attachments.  Will call manually.
    ext.point('io.ox/mail/listview/item/default/row2').disable('paper-clip');
    ext.point('io.ox/mail/listview/item/small/col4').disable('paper-clip');

    ext.point('io.ox/mail/listview/item').extend({
        id: 'checkReload',
        index: 10,
        draw: function (baton) {
            var pooledMail = mailApi.pool.get('detail').get(baton.data.cid);
            if (pooledMail) {
                if (pooledMail.get('guardIcons')) {  // PGP emails may have been already decrypted, etc
                    baton.data.security = pooledMail.get('guardIcons').security;
                    baton.data.attachment = pooledMail.get('guardIcons').attachment;
                }
            }
        }
    });

    ext.point('io.ox/mail/listview/item/default/row2').extend({
        id: 'OGpaper-clip',
        index: 300,
        draw: function (baton) {
            addLock.call(this, baton);
        }
    });

    ext.point('io.ox/mail/listview/item/small/col5').disable('paper-clip');
    ext.point('io.ox/mail/listview/item/small/col5').extend({
        id: 'OGpaper-clipSm',
        index: 300,
        draw: function (baton) {
            addLock.call(this, baton);
        }
    });

    // Check if OxGuard email, and if so, add lock icon.  Add paperclip if applicable
    function addLock(baton) {
        try {
            if (!initialized) {
                listViewInit();
                initialized = true;
            }
            if (baton.data.attachment === undefined) {
                return;
            }
            if (baton.model === undefined) {
                extensions.paperClip.call(this, baton);
                return;
            }
            // Encrypted, we don't know if attachments
            if (baton.model.get('security_info') && baton.model.get('security_info').encrypted) {
                if (!(baton.model.get('security') && baton.model.get('security').decrypted)) {
                    return;
                }
            }
            if (/multipart\/encrypted/.test(baton.model.get('content_type'))) {
                return;
            }
            /// PGP Components
            // Check if decoded
            if (baton.model.get('security') && baton.model.get('security').decrypted) {
                if (baton.model.get('attachment') === true) {
                    extensions.paperClip.call(this, baton);
                } else {
                    $(this).find('.fa-paperclip').hide();  // remove if already added
                }
                return;
            }
            extensions.paperClip.call(this, baton);  // Otherwise, call paperclip
        } catch (ex) {
            console.log('Problem checking list for OG email');
            console.log(ex);
        }
    }
});
