/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.guard.osgi;

import com.openexchange.capabilities.CapabilityService;
import com.openexchange.guard.guest.MailGuestService;
import com.openexchange.guard.guest.impl.GuardGuestFolderHandlerModuleExt;
import com.openexchange.guard.guest.impl.GuardGuestUserService;
import com.openexchange.guard.guest.impl.GuardMailStorageHandler;
import com.openexchange.guard.mail.service.impl.CompositePGPMailRecognizer;
import com.openexchange.guard.mail.service.impl.EncryptedMailServiceImpl;
import com.openexchange.guard.mail.service.impl.GuardAwareMailAccessFactory;
import com.openexchange.guard.mail.service.impl.PGPInlineMailRecognizer;
import com.openexchange.guard.mail.service.impl.PGPMimeMailRecognizer;
import com.openexchange.guard.mail.service.impl.guests.GuardGuestMailProvider;
import com.openexchange.mail.MailProviderRegistry;
import com.openexchange.mail.api.crypto.CryptographicAwareMailAccessFactory;
import com.openexchange.mail.mime.crypto.PGPMailRecognizer;
import com.openexchange.mail.service.EncryptedMailService;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.osgi.HousekeepingActivator;
import com.openexchange.share.core.ModuleHandler;
import com.openexchange.share.groupware.spi.FolderHandlerModuleExtension;

/**
 * {@link MailActivator}
 *
 * @author <a href="mailto:greg.hill@open-xchange.com">Greg Hill</a>
 * @since v2.8.0
 */
public class MailActivator extends HousekeepingActivator {

    private static final String GUARD_GUEST_PROTOCOL = null;

    @Override
    protected Class<?>[] getNeededServices() {
        return new Class<?>[] { MailGuestService.class, CapabilityService.class };  // Require MailGuestService to verify GuardActivator loaded
    }

    @Override
    protected void startBundle() throws Exception {

        //For testing purpose:
        GuardGuestMailProvider guardGuestMailProvider = new GuardGuestMailProvider();
        MailProviderRegistry.registerMailProvider(guardGuestMailProvider.getProtocol().getName(), guardGuestMailProvider);

        registerService(EncryptedMailService.class, new EncryptedMailServiceImpl());

        PGPMailRecognizer recognizer = new CompositePGPMailRecognizer(
            new PGPMailRecognizer[] {
                new PGPMimeMailRecognizer(),
                new PGPInlineMailRecognizer()
            });
        registerService(PGPMailRecognizer.class, recognizer);

        registerService(ModuleHandler.class,
            new GuardMailStorageHandler(
                Services.getService(MailAccountStorageService.class),
                new GuardGuestUserService()));

        registerService(CryptographicAwareMailAccessFactory.class, new GuardAwareMailAccessFactory(recognizer, Services.getService(CapabilityService.class)));

        registerService(FolderHandlerModuleExtension.class, new GuardGuestFolderHandlerModuleExt());

        openTrackers();
    }

}
