/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.management.maintenance.internal;

import javax.management.MBeanException;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import com.google.gson.JsonObject;
import com.openexchange.exception.OXException;
import com.openexchange.guard.GuardMaintenanceService;
import com.openexchange.guard.management.maintenance.GuardMaintenanceMBean;

/**
 * {@link GuardMaintenanceMBeanImpl}
 *
 * @author <a href="mailto:ioannis.chouklis@open-xchange.com">Ioannis Chouklis</a>
 */
// FIXME: Just copied the logic from {@link HandleArgs} class. Needs cleaning up, exception handling.
public class GuardMaintenanceMBeanImpl extends StandardMBean implements GuardMaintenanceMBean {

    private final GuardMaintenanceService maintenanceService;

    /**
     * Initialises a new {@link GuardMaintenanceMBeanImpl}.
     *
     * @param guardMaintenanceService
     *
     * @throws NotCompliantMBeanException
     */
    public GuardMaintenanceMBeanImpl(GuardMaintenanceService guardMaintenanceService) throws NotCompliantMBeanException {
        super(GuardMaintenanceMBean.class);
        this.maintenanceService = guardMaintenanceService;
    }

    @Override
    public void reset(String email) throws MBeanException {
        try {
            maintenanceService.reset(email);
        } catch (OXException e) {
            throw new MBeanException(e);
        }
    }

    @Override
    public void removePIN(String email) throws MBeanException {
        try {
            maintenanceService.removePIN(email);
        } catch (OXException e) {
            throw new MBeanException(e);
        }
    }

    @Override
    public void upgrade(String email, String userid, String cid) throws MBeanException {
        try {
            maintenanceService.upgrade(email, userid, cid);
        } catch (OXException e) {
            throw new MBeanException(e);
        }
    }

    @Override
    public String test(String email) throws MBeanException {
        try {
            return maintenanceService.test(email).toString();
        } catch (OXException e) {
            throw new MBeanException(e);
        }
    }

    @Override
    public TestUserResultImpl testUser(String email) throws MBeanException {
        try {
            JsonObject test = maintenanceService.test(email).get(email).getAsJsonObject();
            return new TestUserResultImpl(test.get("uid").getAsInt(),
                test.get("cid").getAsInt(),
                test.get("user").getAsJsonObject().has("displayName") ? test.get("user").getAsJsonObject().get("displayName").getAsString() : "",
                test.get("user").getAsJsonObject().get("language").getAsString());
        } catch (OXException e) {
            throw new MBeanException(e);
        }
    }

    @Override
    public void deleteUser(String email) throws MBeanException {
        try {
            maintenanceService.delete(email);
        } catch (OXException e) {
            throw new MBeanException(e);
        }
    }

    @Override
    public void resetGuest(String email, boolean force) throws MBeanException {
        try {
            maintenanceService.resetGuest(email, force);
        } catch (OXException e) {
            throw new MBeanException(e);
        }
    }

    @Override
    public void importPublic (String file) throws MBeanException {
        try {
            maintenanceService.importPublic(file);
        } catch (OXException e) {
            throw new MBeanException(e);
        }
    }

    /* (non-Javadoc)
     * @see com.openexchange.guard.management.maintenance.GuardMaintenanceMBean#repair()
     */
    @Override
    public StringBuilder repair(boolean dryRun) throws MBeanException {
        try {
            return maintenanceService.repair(dryRun);
        } catch (OXException e) {
            throw new MBeanException(e);
        }

    }

    /* (non-Javadoc)
     * @see com.openexchange.guard.management.maintenance.GuardMaintenanceMBean#changeUser(java.lang.String, java.lang.String, int, int)
     */
    @Override
    public void changeUser(String email, String newEmail) throws MBeanException {
        try {
            maintenanceService.changeUser(email, newEmail);
        } catch (OXException e) {
            throw new MBeanException(e);
        }

    }

    @Override
    public int createMaster() throws MBeanException {
        try {
            return maintenanceService.createMasterKeys();
        } catch (OXException e) {
            throw new MBeanException(e);
        }

    }
}
