/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.keymanagement.commons;

import java.security.Key;
import java.security.PublicKey;

/**
 * {@link MasterKey}
 *
 * @author <a href="mailto:greg.hill@open-xchange.com">Greg Hill</a>
 * @since v2.10.6
 */
public class MasterKey {

    private String rc, mc;
    private GuardKeys client;
    private GuardKeys masterEncr;
    private Key clientPrivateKey;
    private int index;

    /**
     * Initializes a new {@link MasterKey}.
     *
     * @param rc
     * @param mc
     * @param client Key used for client encryption for passwords, database
     * @param master Key used to encrypt the password recovery
     */
    public MasterKey(String rc, String mc, GuardKeys client, GuardKeys master, int index) {
        this.rc = rc;
        this.mc = mc;
        this.client = client;
        this.masterEncr = master;
        this.index = index;
    }

    public void setClientPrivateKey(Key key) {
        this.clientPrivateKey = key;
    }

    public Key getClientPrivateKey() {
        return clientPrivateKey;
    }

    /**
     * Gets the rc string
     * getRC
     *
     * @return
     */
    public String getRC() {
        return rc;
    }

    /**
     * Gets the mc string
     * getMC
     *
     * @return
     */
    public String getMC() {
        return mc;
    }

    /**
     * Check if the master password, used for password recovery, is avail
     * hasMaster
     *
     * @return
     */
    public boolean hasMaster() {
        return mc != null;
    }

    public String getMasterEncodedPrivate() {
        return masterEncr.getEncodedPrivate();
    }

    public PublicKey getMasterPublic() {
        return masterEncr.getPublicKey();
    }

    public String getMasterSalt() {
        return masterEncr.getSalt();
    }

    public String getClientEncodedPrivate() {
        return client.getEncodedPrivate();
    }

    public String getClientSalt() {
        return client.getSalt();
    }

    public PublicKey getClientPublic() {
        return client.getPublicKey();
    }

    public int getIndex() {
        return index;
    }

}
