/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.email.storage.ogEmail.internal;

class EmailSql {

    static final String DELETE_ALL_FOR_USER_STMT = "DELETE FROM og_email WHERE id = ? AND cid = ?;";
    static final String SELECT_BY_EMAIL_STMT = "SELECT cid, id,email,db FROM og_email WHERE email = ?;";
    static final String INSERT_OR_UPDATE_STMT = "INSERT INTO og_email (email, id, cid, db, hu) VALUES (?, ?, ?, ?, ?) ON DUPLICATE KEY UPDATE id = ?, cid = ?, db = ?";
    static final String SELECT_BY_USERID_STMT = "SELECT cid, id,email,db from og_email WHERE id = ? AND cid = ?";
    static final String SELECT_HIGHEST_GUEST_USERID_STMT = "SELECT MAX(ID) FROM og_email WHERE cid < 0";
    static final String DELETE_ALL_FOR_CONTEXT_STMT = "DELETE FROM og_email WHERE cid = ?";
    static final String SELECT_EMAIL = "SELECT mail from user WHERE cid = ? AND id = ?";
    static final String SELECT_ALL_STMT = "SELECT cid, id,email,db FROM og_email;";
    static final String SELECT_BY_HU = "SELECT cid, id, email, db FROM og_email WHERE hu = ?";
    static final String CHECK_HU = "SELECT hu FROM og_email WHERE cid > 0 and hu IS NOT null";
    static final String GET_COUNT = "SELECT COUNT(email) FROM og_email";
    static final String GET_MISSING_HU_COUNT = "SELECT COUNT(email) FROM og_email WHERE cid > 0 AND hu IS null";
    static final String UPDATE_HU = "UPDATE og_email SET hu = ? WHERE email = ?";
    static final String FIND_MISSING_HU = "SELECT cid, id, email, db FROM og_email WHERE cid > 0 AND hu IS null";
    static final String UPDATE_EMAIL_ADDRESS = "UPDATE og_email SET email = ? WHERE email = ?";
}
