/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.servlets.guest.exceptions;

import com.openexchange.i18n.LocalizableStrings;

/**
 * {@link GuestServletExceptionMessages}
 *
 * @author <a href="mailto:greg.hill@open-xchange.com">Greg Hill</a>
 * @since v7.8.3
 */
public class GuestServletExceptionMessages implements LocalizableStrings {

    // Unable to find the pgp keys for the specified user
    public static final String UNABLE_TO_FIND = "Unable to find the key for user %1$s";
    // A PIN is required for opening the email.  The PIN was configured/specified by the sender
    public static final String PIN_REQUIRED = "A PIN is required to open this email.  The PIN was chosen by the sender.";
    // The account is not a Guest account
    public static final String NOT_GUEST = "This is not a guest account";
    // The account is locked out due to excessive bad login attempts.  This is just a brief error message
    public static final String LOCKOUT = "Lockout";
    // Service unavailable
    public static final String SERVICE_UNAVAILABLE = "Service unavailable, check configuration";
    // The ID of the email is invalid
    public static final String BAD_EMAIL_ID = "Invalid email ID";
    // The token used for authentication is not valid
    public static final String BAD_AUTHENTICATION_MSG = "Authentication token is not valid";

    /**
     * Prevent instantiation.
     */
    private GuestServletExceptionMessages() {}
}
