/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.auth;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.google.gson.JsonObject;
import com.openexchange.exception.OXException;
import com.openexchange.guard.common.servlets.utils.ServletUtils;
import com.openexchange.guard.common.util.JsonUtil;
import com.openexchange.guard.handler.ResponseHandler;
import com.openexchange.guard.inputvalidation.EmailValidator;
import com.openexchange.guard.keymanagement.services.PasswordChangeService;
import com.openexchange.guard.osgi.Services;
import com.openexchange.guard.oxapi.Api;
import com.openexchange.guard.oxapi.OxCookie;
import com.openexchange.guard.servlets.authentication.GuardUserSession;

/**
 * {@link ChangePasswordHandler}
 *
 * @author <a href="mailto:greg.hill@open-xchange.com">Greg Hill</a>
 * @since v2.10.0
 */
public class ChangePasswordHandler {

    private static Logger LOG = LoggerFactory.getLogger(ChangePasswordHandler.class);

    /**
     * Change password
     *
     * @param request
     * @param response
     * @param cookie
     * @return
     * @throws OXException
     * @throws Exception
     */
    public void changepass(HttpServletRequest request, HttpServletResponse response, GuardUserSession userSession, OxCookie cookie) throws OXException {
        JsonObject json = Services.getService(ResponseHandler.class).getJsonAndDecodeEncryptedPasswords(request, userSession.getUserId(), userSession.getContextId());
            // if ox member, verify actually logged in to ui
            if (userSession.getGuardContextId() > 0) {
                Api ap = new Api(cookie, request);
                if (ap.verifyLogin() == false) {
                    response.setStatus(550);
                    return;
                }
            }
            String newpass = JsonUtil.getStringFromJson(json, "newpass", true);
            String question = "";
            if (json.has("question")) {// Sent with new question and answer?
                question = json.get("question").getAsString();
            }
            String answer = "";
            if (json.has("answer")) {
                answer = json.get("answer").getAsString();
            }
            if (json.has("email")) {
                if (!json.get("email").getAsString().equals("")) {
                    answer = new EmailValidator().assertInput(json.get("email").getAsString(), "email");
                }
                if (!answer.equals("")) {
                    question = "e";
                }
            }
            String userEmail = "";
            if (json.has("userEmail")) {
                userEmail = json.get("userEmail").getAsString();
            }
            String oldpass = "";
            String pin = "";
            if (json.has("pin")) {
                pin = json.get("pin").getAsString();
            }
            oldpass = JsonUtil.getStringFromJson(json, "oldpass", true);
            PasswordChangeService passService = Services.getService(PasswordChangeService.class);
            String result = passService.changePassword(userSession.getUserId(),
                userSession.getContextId(),
                userEmail,
                oldpass,
                newpass,
                question,
                answer,
                pin,
                userSession.getGuardSession());
            ServletUtils.sendOK(response, "applicaton/json", result);

    }

}
