/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.update.internal;

import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.openexchange.exception.OXException;
import com.openexchange.guard.configuration.GuardConfigurationService;
import com.openexchange.guard.configuration.GuardProperty;
import com.openexchange.guard.settings.GlobalSettingsStorage;
import com.openexchange.guard.update.GuardUpdateService;
import com.openexchange.guard.update.osgi.Services;

/**
 * {@link GuardUpdateServiceImpl}
 *
 * @author <a href="mailto:martin.schneider@open-xchange.com">Martin Schneider</a>
 * @since v2.4.0
 */
public class GuardUpdateServiceImpl implements GuardUpdateService {

    private static final Logger LOG = LoggerFactory.getLogger(GuardUpdateServiceImpl.class);

    @Override
    public void createMasterKeysIfNecessary() throws OXException {
        if (checkUpgrade()) {
            doUpgrade();
        }
    }

    private boolean checkUpgrade() {
        try {
            GlobalSettingsStorage globalSettingsStorage = Objects.requireNonNull(Services.getService(GlobalSettingsStorage.class), "Missing GlobalSettingsStorage service");
            int previousVersion = Integer.parseInt(globalSettingsStorage.getByKey("version"));

            GuardConfigurationService configService = Services.getService(GuardConfigurationService.class);
            int configuredVersion = configService.getIntProperty(GuardProperty.version);
            return previousVersion < configuredVersion;
        } catch (OXException e) {
            LOG.error("Error while comparing versions. Stop update", e);
        }
        return false;
    }

    /**
     * For future database upgrade action.
     */
    private void doUpgrade() throws OXException {
        GuardConfigurationService configService = Services.getService(GuardConfigurationService.class);
        int version = configService.getIntProperty(GuardProperty.version);
        setCurrent(version);
    }

    private void setCurrent(int version) {
        try {
            GlobalSettingsStorage globalSettingsStorage = Services.getService(GlobalSettingsStorage.class);
            globalSettingsStorage.update("version", Integer.toString(version));
        } catch (OXException e) {
            LOG.error("Error while setting new version.", e);
        }
    }
}
