/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.management.statistics.internal;

import java.lang.management.ManagementFactory;
import java.text.NumberFormat;
import javax.management.MBeanException;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import com.openexchange.exception.OXException;
import com.openexchange.guard.management.osgi.Services;
import com.openexchange.guard.management.statistics.GuardServerStatisticsMBean;
import com.openexchange.guard.oxapi.pooling.HttpConnectionPoolService;

/**
 * MBean statistic implementation
 *
 * @author <a href="mailto:benjamin.gruedelbach@open-xchange.com">Benjamin Gruedelbach</a>
 * @since v2.4.0
 */
public class GuardServerStatisticsMBeanImpl extends StandardMBean implements GuardServerStatisticsMBean {

    //private final HttpPoolingStats stats;

    /**
     * Initialises a new {@link GuardServerStatisticsMBeanImpl}.
     *
     * @throws NotCompliantMBeanException
     */
    public GuardServerStatisticsMBeanImpl() throws NotCompliantMBeanException {
        super(GuardServerStatisticsMBean.class);
    }

    @Override
    public synchronized String getPoolInfo() throws MBeanException {
        HttpConnectionPoolService poolService = getHttpConnectionPoolService();
        return ("HTTP pool connections- In Pool : " + poolService.getStats().getAvailable() + " Active: " + poolService.getStats().getLeased() + " Hold: " + poolService.getStats().getPending());
    }

    @Override
    public synchronized String getMemoryInfo() {
        return ("Total: " + NumberFormat.getIntegerInstance().format(getTotalMemory()) + " Used: " + NumberFormat.getIntegerInstance().format(getUsedMemory()) + " Free: " + NumberFormat.getIntegerInstance().format(getFreeMemory()) + " Max: " + NumberFormat.getIntegerInstance().format(getMaxMemory()));
    }

    @Override
    public synchronized int getPoolCount() throws MBeanException {
        HttpConnectionPoolService poolService = getHttpConnectionPoolService();
        return (poolService.getStats().getAvailable());
    }

    @Override
    public synchronized int getPoolActive() throws MBeanException {
        HttpConnectionPoolService poolService = getHttpConnectionPoolService();
        return (poolService.getStats().getLeased());
    }

    @Override
    public synchronized int getPoolWaiting() throws MBeanException {
        HttpConnectionPoolService poolService = getHttpConnectionPoolService();
        return (poolService.getStats().getPending());
    }

    @Override
    public synchronized long getUsedMemory() {
        Runtime runtime = Runtime.getRuntime();
        return (runtime.totalMemory() - runtime.freeMemory());
    }

    @Override
    public synchronized long getFreeMemory() {
        return (Runtime.getRuntime().freeMemory());
    }

    @Override
    public synchronized long getMaxMemory() {
        return (Runtime.getRuntime().maxMemory());
    }

    @Override
    public synchronized long getTotalMemory() {
        return (Runtime.getRuntime().totalMemory());
    }

    @Override
    public int getThreadCount() {
        return (ManagementFactory.getThreadMXBean().getThreadCount());
    }

    private HttpConnectionPoolService getHttpConnectionPoolService() throws MBeanException {
        try {
            return Services.getService(HttpConnectionPoolService.class);
        } catch (OXException e) {
            throw new MBeanException(e);
        }
    }
}
