/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.keymanagement.services.impl.masterKey;

import com.openexchange.exception.OXException;
import com.openexchange.guard.cipher.GuardCipherService;
import com.openexchange.guard.keymanagement.commons.MasterKey;
import com.openexchange.guard.keymanagement.services.MasterKeyService;

/**
 * {@link AbstractMasterKeyService}
 *
 * @author <a href="mailto:greg.hill@open-xchange.com">Greg Hill</a>
 * @since v2.10.5
 */
public abstract class AbstractMasterKeyService implements MasterKeyService {

    private final GuardCipherService cipher;

    /**
     * Initializes a new {@link AbstractMasterKeyService}.
     *
     * @param cipher The {@link GuardCipherService} to use
     */
    public AbstractMasterKeyService(GuardCipherService cipher) {
        this.cipher = cipher;
    }

    /**
     * Use the cipher service to decrypt the data
     * decrypt
     *
     * @param key Key to use
     * @param data Data to decrypt
     * @param salt Salt
     * @return
     */
    protected String decrypt(MasterKey key, String data, String salt) {
        if (data == null) {
            return null;
        }
        return cipher.decrypt(data, key.getRC(), salt);
    }

    /**
     * Use the cipher service to encrypt the data
     * encrypt
     *
     * @param key to use
     * @param data to encrypt
     * @param salt to use
     * @return
     * @throws OXException
     */
    protected String encrypt(MasterKey key, String data, String salt) throws OXException {
        if (data == null) {
            return null;
        }
        return cipher.encrypt(data, key.getRC(), salt);
    }

}
