/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.keymanagement.commons.trust;

import java.util.HashMap;
import java.util.Map;
import com.openexchange.guard.configuration.GuardConfigurationService;
import com.openexchange.guard.configuration.GuardProperty;
import com.openexchange.guard.keymanagement.commons.osgi.Services;

/**
 * {@link KeySourceFactoryImpl} default implementation for {@link KeySourceFactory}
 *
 * @author <a href="mailto:benjamin.gruedelbach@open-xchange.com">Benjamin Gruedelbach</a>
 * @since v2.10.0
 */
public class KeySourceFactoryImpl implements KeySourceFactory {

    private static final Map<String, GuardProperty> trustLevelCache = new HashMap<String, GuardProperty>();

    /**
     * Internal method to cache a trust level for a given keySource
     *
     * @param keySource The {@link KeySource} to add to the internal cache.
     */
    private static void cacheTrustLevel(KeySource keySource, GuardProperty trustLevelConfigurationProperty) {
        trustLevelCache.put(keySource.getName(), trustLevelConfigurationProperty);
    }

    @Override
    public synchronized KeySource create(String name, GuardProperty trustLevelConfigurationProperty) {
        GuardConfigurationService guardConfiguration = Services.getService(GuardConfigurationService.class);
        KeySource keySource = new KeySource(name, trustLevelConfigurationProperty);
        cacheTrustLevel(keySource, trustLevelConfigurationProperty);
        return keySource;
    }

    @Override
    public synchronized KeySource create(String name) {
        GuardProperty existingTrustLevel = trustLevelCache.get(name);
        if (existingTrustLevel != null) {
            return new KeySource(name, existingTrustLevel);
        }
        throw new IllegalArgumentException("Cannot create KeySource for unknown name \"" + name + "\"");
    }

}
