/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.dns.internal;

import java.io.IOException;
import java.time.Duration;
import java.util.List;
import org.xbill.DNS.Message;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.ResolverListener;
import org.xbill.DNS.TSIG;

/**
 * {@link AbstractResolverDecorator} is an abstract decorator which does not adding behavior and just delegates.
 *
 * @author <a href="mailto:benjamin.gruedelbach@open-xchange.com">Benjamin Gruedelbach</a>
 * @since v2.6.0
 */
public abstract class AbstractResolverDecorator implements Resolver {

    private final Resolver decoratedResolver;

    /**
     * Initializes a new {@link AbstractResolverDecorator}.
     * 
     * @param decoratedResolver
     */
    public AbstractResolverDecorator(Resolver decoratedResolver) {
        this.decoratedResolver = decoratedResolver;
    }

    /**
     * Gets the decorated Resolver
     * 
     * @rteturn The decorated resolver
     */
    public Resolver getDecoratedResolver() {
        return decoratedResolver;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.xbill.DNS.Resolver#setPort(int)
     */
    @Override
    public void setPort(int port) {
        decoratedResolver.setPort(port);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.xbill.DNS.Resolver#setTCP(boolean)
     */
    @Override
    public void setTCP(boolean flag) {
        decoratedResolver.setTCP(flag);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.xbill.DNS.Resolver#setIgnoreTruncation(boolean)
     */
    @Override
    public void setIgnoreTruncation(boolean flag) {
        decoratedResolver.setIgnoreTruncation(flag);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.xbill.DNS.Resolver#setEDNS(int)
     */
    @Override
    public void setEDNS(int level) {
        decoratedResolver.setEDNS(level);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.xbill.DNS.Resolver#setEDNS(int, int, int, java.util.List)
     */
    @Override
    public void setEDNS(int level, int payloadSize, int flags, List options) {
        decoratedResolver.setEDNS(level, payloadSize, flags, options);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.xbill.DNS.Resolver#setTSIGKey(org.xbill.DNS.TSIG)
     */
    @Override
    public void setTSIGKey(TSIG key) {
        decoratedResolver.setTSIGKey(key);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.xbill.DNS.Resolver#setTimeout(int, int)
     */
    @Override
    public void setTimeout(int secs, int msecs) {
        decoratedResolver.setTimeout(secs, msecs);
    }

    @Override
    public void setTimeout(Duration timeout) {
        decoratedResolver.setTimeout(timeout);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.xbill.DNS.Resolver#setTimeout(int)
     */
    @Override
    public void setTimeout(int secs) {
        decoratedResolver.setTimeout(secs);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.xbill.DNS.Resolver#send(org.xbill.DNS.Message)
     */
    @Override
    public Message send(Message query) throws IOException {
        return decoratedResolver.send(query);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.xbill.DNS.Resolver#sendAsync(org.xbill.DNS.Message, org.xbill.DNS.ResolverListener)
     */
    @Override
    public Object sendAsync(Message query, ResolverListener listener) {
        return decoratedResolver.sendAsync(query, listener);
    }
}
