/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.common.util;

import java.math.BigInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * {@link LongUtil}
 *
 * @author <a href="mailto:ioannis.chouklis@open-xchange.com">Ioannis Chouklis</a>
 */
public final class LongUtil {

    private static final Logger logger = LoggerFactory.getLogger(LongUtil.class);

    /**
     * Converts the specified String to a long value
     * 
     * @param string The string to convert to a long
     * @return The long value of the string
     */
    public static Long stringToLong(String string) {
        return new BigInteger(string, 16).longValue();
    }

    /**
     * Parses the specified string as a hex string
     * 
     * @param string the string to parse
     * @return The hex representation of the string
     */
    public static String getHex(String string) {
        try {
            return Long.toHexString(Long.parseLong(string)).substring(8);
        } catch (Exception ex) {
            logger.error("Error parsing long string " + string, ex);
            return null;
        }
    }

    /**
     * Parses the specified string as hex
     * 
     * @param id
     * @return
     */
    public static String getLongHex(String id) {
        try {
            return Long.toHexString(Long.parseLong(id));
        } catch (Exception ex) {
            logger.error("Error parsing long string " + id, ex);
            return null;
        }
    }

    /**
     * Long to Hex String
     * 
     * @param id
     * @return
     */
    public static String longToHexString(long id) {
        return Long.toHexString(id);
    }

    /**
     * Long to hex string, truncated
     * 
     * @param id
     * @return
     */
    public static String longToHexStringTruncated(long id) {
        if (Long.toHexString(id).length() < 8) {
            return (Long.toHexString(id));
        }
        return (Long.toHexString(id).substring(8));
    }
}
