/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.cipher.internal;

import java.security.Key;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.openexchange.exception.OXException;
import com.openexchange.guard.cipher.GuardCipherAlgorithm;

/**
 * {@link GuardRSACipherServiceImpl}
 *
 * @author <a href="mailto:ioannis.chouklis@open-xchange.com">Ioannis Chouklis</a>
 */
public class GuardRSACipherServiceImpl extends AbstractGuardCipherService {

    private static final Logger LOG = LoggerFactory.getLogger(GuardAESCipherServiceImpl.class);

    /**
     * Initializes a new {@link GuardRSACipherServiceImpl}.
     *
     * @param cipherAlgorithm The cipher algorithm
     * @throws OXException If the specified cipher algorithm does not exist, or if the key length of the specified algorithm exceeds the maximum defined
     */
    public GuardRSACipherServiceImpl(GuardCipherAlgorithm cipherAlgorithm) throws OXException {
        super(cipherAlgorithm);
    }

    @Override
    public String encrypt(String data, Key secretKey) {
        byte[] cipherText = null;
        try {
            // Get an RSA cipher object
            final Cipher cipher = getCipher();

            // Encrypt the plain text using the public key
            cipher.init(Cipher.ENCRYPT_MODE, secretKey);
            cipherText = cipher.doFinal(data.getBytes("UTF-8"));
        } catch (Exception e) {
            LOG.error("Error RSA encrypt: " + e.getMessage(), e);
        }
        return (Base64.encodeBase64String(cipherText));
    }

    @Override
    public String encrypt(String data, String base64Key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String encrypt(String data, String password, String salt) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String decrypt(String data, String password, String salt, int keyLength) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String decrypt(String data, String password, String salt) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String decrypt(String data, String base64Key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String decrypt(String data, Key secretKey) {
        // Passed bad private key
        if (secretKey == null) {
            //TODO: throw illegal argument exception?
            return null;
        }
        byte[] text = Base64.decodeBase64(data);
        byte[] dectyptedText = null;
        try {
            // Get an RSA cipher object and print the provider
            final Cipher cipher = getCipher();

            // Decrypt the text using the secretKey
            cipher.init(Cipher.DECRYPT_MODE, secretKey);
            dectyptedText = cipher.doFinal(text);
            return new String(dectyptedText, "UTF-8");

        } catch (Exception ex) {
            //TODO throw exception
            LOG.error("Problem decoding RSA: " + ex.getMessage(), ex);
            return null;
        }

    }

    @Override
    public String getRandomKey() {
        throw new UnsupportedOperationException();
    }
}
