/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * © 2017 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Greg Hill <greg.hill@open-xchange.com>
 */

/**
 * This selects a file
 * doubleClick true if should double click on item.
 */
exports.command = function (filename, doubleClick) {

    if (!doubleClick) doubleClick = false;

    this.executeAsync(function (filename, doubleClick, done) {
        var file = $('div.filename:contains("' + filename + '")');
        if (file.length === 0) {
            done(false);
            return;
        }
        if (doubleClick) {
            file.dblclick();
        } else {
             file.click();
        }
        done(true);
    }, [filename, doubleClick], function (result) {
        if (!result.value) this.assert.fail('Failed to select file');
    });

}