/**
 * I work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. I work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under I license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * © 2017 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Greg Hill <greg.hill@open-xchange.com>
 */

/// <reference path="../../steps.d.ts" />

Feature('Wipe Tests');

Before(async function (users) {
    await users.create();
});

After(async function (users) {
    await users.removeAll();
});

async function loadEmails(I, user, count) {
    var promises = [];
    for (var i = 0; i < count; i++ ){ 
        var data = {
            attachments: [{
                content: 'Test content ' + i,
                content_type: 'text/html',
                disp: 'inline'
            }],
            from: [[user.get('display_name'), user.get('primaryEmail')]],
            sendtype: 0,
            subject: 'Test subject ' + i,
            to: [[user.get('display_name'), user.get('primaryEmail')]],
            security: {
                encrypt: true,
                sign: false
            }
        };
        promises.push(I.haveMail(data));
    }
    await Promise.all(promises);
    I.waitForElement('#io-ox-refresh-icon .fa-spin');
    I.waitForDetached('#io-ox-refresh-icon .fa-spin');
    I.click('#io-ox-refresh-icon');
    I.waitForVisible('.io-ox-mail-window .leftside ul li.unread')
}

Scenario ('I remove decrypted emails when moving between emails', async function (I, users) {

    const o = {
        user: users[0]
    };
    const userdata = o.user.userdata;
    await I.setupUser(o, true);  // need advanced settings
    await I.haveSetting('oxguard//wipe', 'true', { user: o.user, noCache: true });

    I.login('app=io.ox/mail', o);

    await I.verifyUserSetup(userdata);
 
 

    await loadEmails(I, users[0], 2);

    var subject = 'Test subject 0';
    await I.selectEmailNumber(1);

    I.waitForElement('.og_password input.form-control.password_prompt');
    I.insertCryptPassword('.og_password input.form-control.password_prompt', userdata);
    I.click('.btn.oxguard_passbutton');
    I.wait(1);
    // password prompt gone (decyrpted)
    I.waitForInvisible('.og_password input.form-control.password_prompt');

    await I.selectEmailNumber(2);
    // Switch to another email
    I.waitForElement('.og_password input.form-control.password_prompt');

    await I.selectEmailNumber(1);
    // Come back and verify password prompt returned
    I.waitForElement('.og_password input.form-control.password_prompt');
});

Scenario ('I remove decrypted emails when switching apps', async function (I, users) {

    const o = {
        user: users[0]
    };
    const userdata = o.user.userdata;
    await I.setupUser(o, true);  // need advanced settings
    await I.haveSetting('oxguard//wipe', 'true', { user: o.user, noCache: true });

    I.login('app=io.ox/mail', o);

    await I.verifyUserSetup(userdata);
 
 

    await loadEmails(I, users[0], 2);

    var subject = 'Test subject 0';
    await I.selectEmailNumber(1);

    I.waitForElement('.og_password input.form-control.password_prompt');
    I.insertCryptPassword('.og_password input.form-control.password_prompt', userdata);
    I.click('.btn.oxguard_passbutton');
    I.wait(1);
    // password prompt gone (decyrpted)
    I.waitForInvisible('.og_password input.form-control.password_prompt');

    await I.openApp('Drive');
    I.waitForVisible('ul.file-list-view.complete');
    await I.openApp('Mail');
    I.waitForVisible('ul.list-view');
    await I.selectEmailNumber(1);
    // Come back and verify password prompt returned
    I.waitForElement('.og_password input.form-control.password_prompt');
});

Scenario ('I remove decrypted emails but not within threads', async function (I, users) {

    const o = {
        user: users[0]
    };
    const userdata = o.user.userdata;
    await I.setupUser(o, true);  // need advanced settings
    await I.haveSetting('oxguard//wipe', 'true', { user: o.user, noCache: true });

    I.login('app=io.ox/mail', o);

    await I.verifyUserSetup(userdata);
    I.click('Sort');
    I.click('Conversations');
    await loadEmails(I, users[0], 2);
    var subject = 'Test subject 0';

    // setup one thread and one singleton
    await I.selectEmailNumber(1);
    I.waitForVisible('.inline-toolbar a[data-action="io.ox/mail/actions/reply"]');
    I.waitForElement('.btn.oxguard_passbutton');
    I.waitForElement('input.form-control.password_prompt');
    I.insertCryptPassword('input.form-control.password_prompt', userdata);
    I.click('.btn.oxguard_passbutton');
    I.verifyDecryptedMail(subject, 'Test content');
    I.click('Reply');
    I.auth(userdata);
    I.waitForInvisible('.window-blocker.io-ox-busy');
    I.waitForVisible('.io-ox-mail-compose textarea.plain-text,.io-ox-mail-compose .contenteditable-editor');
    I.waitForVisible('.io-ox-mail-compose-window .editor iframe');
    I.wait(1);
    // Change contents to ReplyTest to verify later
    within({ frame: '.io-ox-mail-compose-window .editor iframe' }, async () => {
        I.see('wrote:');
        I.click('.mce-content-body');
        I.fillField('.mce-content-body', 'ReplyTest');
        });

    I.waitForVisible('i.fa.fa-key.oxguard_token.key_tooltip.trusted_key');
    I.click('Send');
    I.waitForVisible('.io-ox-mail-window .leftside');
    I.wait(1);
    I.click('#io-ox-refresh-icon');
    I.waitForVisible('.thread-size .number')
    // OK, test it out now.
    I.selectEmailNumber(1);

    // Still decrypted with reply
    within({ frame: '.multiple-messages article:nth-of-type(2) iframe' }, () => {
        I.see('Test content');
    });
    // Switch to the reply
    I.wait(1);
    await I.openThreadEmail(1);
    I.waitForVisible('.btn.oxguard_passbutton');
    I.waitForElement('input.form-control.password_prompt');
    I.insertCryptPassword('input.form-control.password_prompt', userdata);
    I.click('.btn.oxguard_passbutton');
    I.waitForElement('.multiple-messages article:nth-of-type(1) iframe');
    within({ frame: '.multiple-messages article:nth-of-type(1) iframe' }, () => {
        I.see('ReplyTest');
    });

    // FIrst is still readable (wasn't removed)
    within({ frame: '.multiple-messages article:nth-of-type(2) iframe' }, () => {
        I.see('Test content');
    });

    // OK, let's switch to next email
    I.selectEmailNumber(2);
    I.wait(2);

    // Switch back
    I.selectEmailNumber(1);
    // Verify both have been wiped
    I.wait(1);
    I.see('Secure Email', '.multiple-messages article:nth-of-type(1)');
    await I.openThreadEmail(2);
    I.wait(1);
    I.waitForVisible('.btn.oxguard_passbutton', '.multiple-messages article:nth-of-type(2)');
    I.see('Secure Email', '.multiple-messages article:nth-of-type(2)');

});

