/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * © 2017 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Greg Hill <greg.hill@open-xchange.com>
 */

/// <reference path="../../steps.d.ts" />

Feature('Send Encrypted To Self');

const largeFilename = 'e2e/testFiles/testLargeData.txt';
const fs = require('fs');

Before(async function (users) {
    await users.create();
    
    await new Promise(function (resolve, reject) {
        var fileData = '';
        for(var i = 0; i < 2500000; i++) {
            fileData += 'test ';
        }
        fs.writeFile(largeFilename, fileData, (err) => {
                resolve();
        });

    });
    
});

After(async function (users) {
    await users.removeAll();
    fs.unlinkSync(largeFilename);
});

async function sendMail(I, subject, data, userdata) {
    // Open compose
    I.sendEmail(userdata, subject, data);

    I.waitForVisible('.io-ox-mail-window .leftside');
    I.click('#io-ox-refresh-icon');
    I.waitForVisible('.io-ox-mail-window .leftside ul li.unread');
    I.click('.io-ox-mail-window .leftside ul li.unread');
    I.waitForVisible('.io-ox-mail-window .mail-detail-pane .subject');
    I.see(subject);

    // Decrypt
    I.waitForElement('.btn.oxguard_passbutton');
    I.waitForElement('.og_password input.form-control.password_prompt');
    I.insertCryptPassword('.og_password input.form-control.password_prompt', userdata);
    I.click('.btn.oxguard_passbutton');

    I.verifyDecryptedMail(subject, data);
}

Scenario('Compose and receive encrypted email', async function (I, users) {

    const o = {
        user: users[0]
    };
    const userdata = o.user.userdata;

    await I.setupUser(o, true);
    
    // Log in as User 0
    I.login('app=io.ox/mail', o);
    I.waitForVisible('.io-ox-mail-window .window-body');

    I.verifyUserSetup(userdata);  // Verify user has Guard setup

    var random = Math.floor((Math.random() * 100000));
    var subject = "Test Subject " + random;
    var data = "Test data " + random;

    await sendMail(I, subject, data, userdata);

    // OK, done
    I.logout();

});

Scenario('Test umlauts, compose and receive encrypted email', async function (I, users) {

    const o = {
        user: users[0]
    };
    const userdata = o.user.userdata;

    await I.setupUser(o, true);
    
    // Log in as User 0
    I.login('app=io.ox/mail', o);
    I.waitForVisible('.io-ox-mail-window .window-body');

    I.verifyUserSetup(userdata);  // Verify user has Guard setup

    var random = Math.floor((Math.random() * 100000));
    var subject = "Üben Subject " + random;
    var data = "die Prüfung " + random;

    await sendMail(I, subject, data, userdata);

    // OK, done
    I.logout();

});

Scenario('Compose and receive encrypted pgp-inline email', async function (I, users) {

    const o = {
        user: users[0]
    };
    const userdata = o.user.userdata;

    await I.setupUser(o, true);
    
    // Log in as User 0
    I.login('app=io.ox/mail', o);
    I.waitForVisible('.io-ox-mail-window .window-body');

    I.verifyUserSetup(userdata);  // Verify user has Guard setup

    var random = Math.floor((Math.random() * 100000));
    var subject = "Test Subject " + random;
    var data = "Test data " + random;

    // Open compose
    I.sendEmail(userdata, subject, data, undefined, { inline: true });

    I.waitForVisible('.io-ox-mail-window .leftside');
    I.click('#io-ox-refresh-icon');
    I.waitForVisible('.io-ox-mail-window .leftside ul li.unread');
    I.click('.io-ox-mail-window .leftside ul li.unread');
    I.waitForVisible('.io-ox-mail-window .mail-detail-pane .subject');
    I.see(subject);

    // Decrypt
    I.waitForElement('.btn.oxguard_passbutton');
    I.waitForElement('.og_password input.form-control.password_prompt');
    I.insertCryptPassword('.og_password input.form-control.password_prompt', userdata);
    I.click('.btn.oxguard_passbutton');

    I.verifyDecryptedMail(subject, data);

    // OK, done
    I.logout();

});

/*
Scenario('Compose and receive large encrypted email', async function (I, users) {

    const o = {
        user: users[0]
    };
    const userdata = o.user.userdata;

    await I.setupUser(o, true);
    
    // Log in as User 0
    I.login('app=io.ox/mail', o);
    I.waitForVisible('.io-ox-mail-window .window-body');

    I.verifyUserSetup(userdata);  // Verify user has Guard setup

    var random = Math.floor((Math.random() * 100000));
    var subject = "Test Subject " + random;
    var data = "Test data " + random;

    // Mark inbox as all read
    I.selectFolder('Inbox');
    I.waitForVisible('.selected .contextmenu-control');
    I.click('.selected .contextmenu-control');
    I.click('.dropdown.open a[data-action="markfolderread"]');

    // Open compose

    I.sendEmail(userdata, subject, data, largeFilename);

    I.waitForVisible('.io-ox-mail-window .leftside', 20);
    I.click('#io-ox-refresh-icon');
    I.waitForVisible('.io-ox-mail-window .leftside ul li.unread', 20);
    I.click('.io-ox-mail-window .leftside ul li.unread');
    I.waitForVisible('.io-ox-mail-window .mail-detail-pane .subject');
    I.see(subject);

    // Decrypt
    I.waitForElement('.btn.oxguard_passbutton');
    I.waitForElement('input.form-control.password_prompt');
    I.insertCryptPassword('input.form-control.password_prompt', userdata);
    I.click('.btn.oxguard_passbutton');

    I.verifyDecryptedMail(subject, data);

    // Verify Attachment
    I.waitForVisible('a[data-action="io.ox/mail/attachment/actions/view"]');
    I.click('a[data-action="io.ox/mail/attachment/actions/view"]');

    // Verify password prompt
    I.auth(userdata);

    I.waitForVisible('.white-page.letter.plain-text', 60);
    I.see('test test test', '.plain-text');

    // Close it
    I.click('a[data-action="io.ox/core/viewer/actions/toolbar/close"]');
    I.waitForVisible('.io-ox-mail-window .leftside');

    // OK, done
    I.logout();

});
*/
