/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * © 2017 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Greg Hill <greg.hill@open-xchange.com>
 */

/**
 * This sends a new email to recipient
 */

module.exports  = function (userdata, subject, data, pin) {
       var optionsDropdown = locate({ css: '[data-extension-id="composetoolbar-menu"] a[aria-label="Options"]' }).as('Options dropdown');

       // Open compose
       this.wait(2);
       this.click('Compose');
       this.waitForVisible('.window-blocker.io-ox-busy');
       this.waitForInvisible('.window-blocker.io-ox-busy');
       this.waitForVisible('.io-ox-mail-compose textarea.plain-text,.io-ox-mail-compose .contenteditable-editor');

       // Mark as secure
       this.click('.toggle-encryption');
       this.waitForVisible('#ogPassword');
        this.fillField('#ogPassword', userdata.password);
        this.click('.btn[data-action="ok"]');
       this.waitForVisible('.fa.fa-2x.encrypted');

       // Verify HTML
       this.click(optionsDropdown);
       this.click('HTML');
       this.waitForVisible('.io-ox-mail-compose .editor .mce-panel');

       // Insert test data
       this.fillField('.io-ox-mail-compose div[data-extension-id="to"] input.tt-input', userdata.email1);
       this.fillField('.io-ox-mail-compose [name="subject"]', subject);
       var I = this;
       within({ frame: '.io-ox-mail-compose-window .editor iframe' }, async () => {
           I.fillField('.mce-content-body', data);
       });

       // Verify icon is next to recipient names
       this.waitForVisible('i.fa-male', 10);
       this.moveCursorTo('i.fa-male', 2, 2);
       //this.waitForVisible('.tooltip');
       //this.see('guest', '.tooltip');

       // Send
       this.click('Send');

       // Add guest message
       this.waitForVisible('#message');
       this.see('Recipient Options');
       this.fillField('.og_guest_message', 'Test introduction text');

       this.click('OK');

       if (!pin) {  // Additional handling required for pin
        this.waitForVisible('.io-ox-mail-window .leftside');
        I.wait(1);
        I.waitForInvisible('.mail-progress');
       }


};
