/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016-2020 OX Software GmbH
 * Author Greg Hill <greg.hill@open-xchange.com>
 */

define('pgp_local/register', [
    'apps/oxguard/crypto/openpgp.min.js',
    'gettext!oxguard',
    'settings!oxguard',
    'pgp_local/storage'
], function (openpgp, gt, settings, storage) {

    'use strict';

    openpgp.initWorker({ path: ox.root + '/apps/oxguard/crypto/openpgp.worker.min.js' + '?' + ox.base });

    window.openpgp = openpgp;
    var keyRing = new openpgp.Keyring();
    window.keyRing = keyRing;

    function storeKeys(keys) {
        var armoredKeys = [];
        if (keys.length) {
            for (var i = 0; i < keys.length; i++) {
                armoredKeys.push(keys[i].armor());
            }
            storage.save(ox.user_id, armoredKeys);
        } else {
            storage.deleteKeys(ox.user_id);
        }
    }

    function loadKeys() {
        var def = $.Deferred();
        storage.get(ox.user_id)
        .done(function (armoredKeys) {
            if (armoredKeys !== null && armoredKeys.length !== 0) {
                for (var i = 0; i < armoredKeys.length; i++) {
                    keyRing.privateKeys.importKey(armoredKeys[i]);
                }
            }
        })
        .always(function () {
            def.resolve();
        });
        return def;
    }

    var localPgp = {
        promptPrivate: function () {
            var def = $.Deferred();
            require(['pgp_local/promptKeyPaste'], function (prompt) {
                prompt.promptToPaste(gt('Paste Private Key'))
                .done(function (data) {
                    keyRing.privateKeys.importKey(data);
                    storeKeys(keyRing.privateKeys.keys);
                    prompt.promptUpload();
                    def.resolve();
                })
                .fail(function () {
                    def.reject();
                });
            });
            return def;
        },
        loadPrivate: function () {
            loadKeys().then(function () {
                if (keyRing.privateKeys.keys && keyRing.privateKeys.keys.length > 0) {
                    if (!settings.get('localKeys')) settings.set('localKeys', true).save();  // Make sure settings is cleared
                } else if (settings.get('localKeys')) {
                    settings.clear('localKeys');
                    settings.save();  // Make sure settings is cleared
                }
            });
        },
        storeKeys: function () {
            storeKeys(keyRing.privateKeys.keys);
        }
    };

    return localPgp;

});
