/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.servlets.guest.responses;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import javax.mail.MessagingException;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.openexchange.guard.guest.GuardGuestEmail;
import com.openexchange.guard.guest.metadata.storage.GuardGuestEmailMetadata;
import com.openexchange.guard.servlets.responses.JsonInputStreamSerializer;

/**
 * {@link GuardGuestEmailResponse}
 *
 * @author <a href="mailto:benjamin.gruedelbach@open-xchange.com">Benjamin Gruedelbach</a>
 * @since v7.10.0
 */
public class GuardGuestEmailResponse {

    private final GuardGuestEmail email;

    /**
     * Initializes a new {@link GuardGuestEmailResponse}.
     *
     * @param email The email
     */
    public GuardGuestEmailResponse(GuardGuestEmail email) {
        this.email = Objects.requireNonNull(email, "email must not be null");
    }

    /**
     * Gets the owner of the email
     *
     * @return The owner of the email
     */
    public String getOwner() {
        return email.getOwner().getIdentity();
    }

    /**
     * Gets the unique identifier of the email
     *
     * @return The unique identifier
     */
    public String getId() {
        return email.getItemId();
    }


    /**
     * Gets an InputStream to the email's content
     *
     * @return The InputStream for the content
     * @throws IOException
     * @throws MessagingException
     */
    @JsonSerialize(using= JsonInputStreamSerializer.class)
    public InputStream getContent() throws IOException, MessagingException {
       return email.getMessgeStream();
    }

    /**
     * Gets the meta data of the email
     *
     * @return The meta data of the email
     */
    public GuardGuestEmailMetadata getMetaData() {
        return email.getMetaData();
    }
}
