/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.wks.servlets;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.omg.CORBA.portable.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.openexchange.exception.OXException;
import com.openexchange.guard.common.servlets.utils.ServletUtils;
import com.openexchange.guard.common.util.CipherUtil;
import com.openexchange.guard.wks.internal.GetKeysByHu;

/**
 *
 * {@link WksGetAction} Handles incoming WebKey Srvice get actions
 *
 * @author <a href="mailto:greg.hill@open-xchange.com">Greg Hill</a>
 * @since v2.10.0
 */
public class WksGetAction {

    private static final Logger logger = LoggerFactory.getLogger(WksGetAction.class);
    private final HttpServletResponse response;
    private final String search;
    private final String domain;

    /**
     * Initializes a new {@link WksGetAction}.
     *
     * @param response
     * @param search
     */
    public WksGetAction(HttpServletResponse response, String search, String domain) {
        this.response = response;
        this.search = search;
        this.domain = domain;
    }


    /**
     * Performs the get action
     *
     * @throws OXException
     * @throws IOException
     */
    public void doAction() throws OXException, IOException {
        PGPPublicKeyRing ring = GetKeysByHu.getKeys(search, domain);
        if (ring != null) {
            logger.debug("WKS: Key found, exporting");
            response.setContentType("application/octet-stream");
            ServletOutputStream out = response.getOutputStream();
            out.write(ring.getEncoded(true));
            out.close();
        } else {
            logger.debug("WKS: No key found");
            ServletUtils.sendResponse(response, 404, "Not Found");
        }

    }
}
