/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.pgpcore.services.exceptions;

import com.openexchange.i18n.LocalizableStrings;

/**
 * {@link PGPCoreServicesExceptionMessages}
 *
 * @author <a href="mailto:benjamin.gruedelbach@open-xchange.com">Benjamin Gruedelbach</a>
 * @since v2.4.2
 */
public final class PGPCoreServicesExceptionMessages implements LocalizableStrings {

    // Unable to retrieve recipients key, with specified key id(s)
    public static final String RECIPIENT_KEY_NOT_FOUND = "Unable to retrieve recipient's key (%1$s)";
    // Unable to retrieve signing key, with key Ids or email addresses in variable
    public static final String SIGNING_KEY_NOT_FOUND = "Unable to retrieve signing key (%1$s)";
    // Encryption error with error appended
    public static final String ENCRYPTION_ERROR = "An PGP encryption error occured: %1$s";
    // Decryption error with error appended
    public static final String DECRYPTION_ERROR = "An PGP decryption error occured: %1$s";
    // Signing error with error appended
    public static final String SIGNING_ERROR = "An PGP signing error occured: %1$s";
    // Signature verification error with error appended
    public static final String SIGNATURE_VERIFICATION_ERROR = "An PGP signature verification error occured: %1$s";
    // Unexpected error with error appended
    public static final String UNEXPECTED_ERROR = "Unexpected error occured: %1$s";
    // Unable to parse recipient address(es)
    public static final String RECIPIENT_PARSING_ERROR = "Unable to parse the given recipient (%1$s)";
    // The email message is not a proper multipart message (type of email)
    public static final String NOT_A_MULTIPART_MSG_ERROR = "The provided message is not a proper multipart message";
    // Signature found, but the data it was signing wasn't found
    public static final String SIGNATURE_ERROR_NO_SIGNED_DATA_MSG  = "No signed data found in email";
    // Unable to find a signature in the email
    public static final String SIGNATURE_ERROR_NO_SIGNATURE_MSG  = "No signature found in email";

    private PGPCoreServicesExceptionMessages() {}
}
