package com.openexchange.guard.guestreset.exceptions;

import com.openexchange.i18n.LocalizableStrings;

public class GuestResetExceptionMessages implements LocalizableStrings {

    // Unable to find the guest account
    public static final String UNKNOWN_GUEST_ACCOUNT_MSG = "Unable to find guest account";
    // Unable to reset the user with the specified email address
    public static final String UNABLE_TO_RESET_MSG = "Unable to reset user with email '%1$s'.";
    // Password recovery exists for the user.  Error displayed if trying to hard reset a user but recovery exists.
    public static final String RECOVERY_EXISTS_MSG = "Recovery exists for the user %1$s'.";
    // Error retrieving token with error appended
    public static final String TOKEN_RETIEVAL_ERROR_MSG = "Error retrieving token: %1$s'.";
    // Error saving token
    public static final String TOKEN_SAVE_ERROR_MSG = "Error saving token %1$s'.";
    // Token is invalid
    public static final String BAD_TOKEN_MSG = "Invalid token %1$s'.";
    // The email address specified is invalid
    public static final String BAD_EMAIL_ADDRESS_MSG = "Invalid email address %1$s'.";
    // Passowrd must be at least %1 characters long
    public static final String MIN_PASSWORD_LENGTH_MSG = "Passwords must be at least %1$s characters";

    private GuestResetExceptionMessages() {
        super();
    }
}