/*
 * Decompiled with CFR 0.152.
 */
package com.j256.simplemagic.logger;

import com.j256.simplemagic.logger.Log;
import com.j256.simplemagic.logger.LoggerFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;

public class LocalLog
implements Log {
    public static final String LOCAL_LOG_LEVEL_PROPERTY = "com.j256.simplemagic.logger.level";
    public static final String LOCAL_LOG_FILE_PROPERTY = "com.j256.simplemagic.logger.file";
    public static final String LOCAL_LOG_PROPERTIES_FILE = "/simplemagicLocalLog.properties";
    private static final Log.Level DEFAULT_LEVEL = Log.Level.DEBUG;
    private static final ThreadLocal<DateFormat> dateFormatThreadLocal = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");
        }
    };
    private static PrintStream printStream;
    private static final List<PatternLevel> classLevels;
    private final String className;
    private final Log.Level level;

    public LocalLog(String className) {
        this.className = LoggerFactory.getSimpleClassName(className);
        Log.Level level = null;
        if (classLevels != null) {
            for (PatternLevel patternLevel : classLevels) {
                if (!patternLevel.pattern.matcher(className).matches() || level != null && patternLevel.level.ordinal() >= level.ordinal()) continue;
                level = patternLevel.level;
            }
        }
        if (level == null) {
            String levelName = System.getProperty(LOCAL_LOG_LEVEL_PROPERTY);
            if (levelName == null) {
                level = DEFAULT_LEVEL;
            } else {
                Log.Level matchedLevel;
                try {
                    matchedLevel = Log.Level.valueOf(levelName.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Level '" + levelName + "' was not found", e);
                }
                level = matchedLevel;
            }
        }
        this.level = level;
    }

    public static void openLogFile(String logPath) {
        if (logPath == null) {
            printStream = System.out;
        } else {
            try {
                printStream = new PrintStream(new File(logPath));
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException("Log file " + logPath + " was not found", e);
            }
        }
    }

    @Override
    public boolean isLevelEnabled(Log.Level level) {
        return this.level.isEnabled(level);
    }

    @Override
    public void log(Log.Level level, String msg) {
        this.printMessage(level, msg, null);
    }

    @Override
    public void log(Log.Level level, String msg, Throwable throwable) {
        this.printMessage(level, msg, throwable);
    }

    void flush() {
        printStream.flush();
    }

    static List<PatternLevel> readLevelResourceFile(InputStream stream) {
        List<PatternLevel> levels = null;
        if (stream != null) {
            try {
                levels = LocalLog.configureClassLevels(stream);
            }
            catch (IOException e) {
                System.err.println("IO exception reading the log properties file '/simplemagicLocalLog.properties': " + e);
            }
            finally {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return levels;
    }

    private static List<PatternLevel> configureClassLevels(InputStream stream) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        ArrayList<PatternLevel> list = new ArrayList<PatternLevel>();
        while ((line = reader.readLine()) != null) {
            Log.Level level;
            if (line.length() == 0 || line.charAt(0) == '#') continue;
            String[] parts = line.split("=");
            if (parts.length != 2) {
                System.err.println("Line is not in the format of 'pattern = level': " + line);
                continue;
            }
            Pattern pattern = Pattern.compile(parts[0].trim());
            try {
                level = Log.Level.valueOf(parts[1].trim());
            }
            catch (IllegalArgumentException e) {
                System.err.println("Level '" + parts[1] + "' was not found");
                continue;
            }
            list.add(new PatternLevel(pattern, level));
        }
        return list;
    }

    private void printMessage(Log.Level level, String message, Throwable throwable) {
        if (!this.isLevelEnabled(level)) {
            return;
        }
        StringBuilder sb = new StringBuilder(128);
        DateFormat dateFormat = dateFormatThreadLocal.get();
        sb.append(dateFormat.format(new Date()));
        sb.append(" [").append(level.name()).append("] ");
        sb.append(this.className).append(' ');
        sb.append(message);
        printStream.println(sb.toString());
        if (throwable != null) {
            throwable.printStackTrace(printStream);
        }
    }

    static {
        InputStream stream = LocalLog.class.getResourceAsStream(LOCAL_LOG_PROPERTIES_FILE);
        List<PatternLevel> levels = LocalLog.readLevelResourceFile(stream);
        classLevels = levels;
        String logPath = System.getProperty(LOCAL_LOG_FILE_PROPERTY);
        LocalLog.openLogFile(logPath);
    }

    private static class PatternLevel {
        Pattern pattern;
        Log.Level level;

        public PatternLevel(Pattern pattern, Log.Level level) {
            this.pattern = pattern;
            this.level = level;
        }
    }
}

