/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.guest.metadata.storage.impl;

/**
 * {@link GuestEmailMetaDataSql}
 *
 * @author <a href="mailto:benjamin.gruedelbach@open-xchange.com">Benjamin Gruedelbach</a>
 * @since v7.10.0
 */
public class GuestEmailMetaDataSql {

    public static final String SELECT_BY_ID                  = "SELECT itemID , version , folderId , contentType , mimeType, mailFrom, mailTo, mailCc, mailBcc, subject, messageFlags, size, sentDate, receivedDate, colorLabel FROM GuestEmailMetaData WHERE itemID = ?;";
    public static final String SELECT_BY_FOLDER              = "SELECT itemID , version , folderId , contentType , mimeType, mailFrom, mailTo, mailCc, mailBcc, subject, messageFlags, size, sentDate, receivedDate, colorLabel FROM GuestEmailMetaData WHERE ownerId = ? AND ownerCid= ? AND folderId = ?;";
    public static final String INSERT                        = "INSERT INTO GuestEmailMetaData (itemID , version , ownerId, ownerCid, folderId , contentType , mimeType, mailFrom, mailTo, mailCc, mailBcc, subject, messageFlags, size, sentDate, receivedDate, colorLabel) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?);";
    public static final String UPDATE_MESSAGE_FLAGS          = "UPDATE GuestEmailMetaData SET messageFlags = ? WHERE itemId = ?;";
    public static final String UPDATE_COLOR_LABEL            = "UPDATE GuestEmailMetaData SET colorLabel = ? where itemId = ?;";
    public static final String UPDATE_FOLDER_ID              = "UPDATE GuestEmailMetaData SET folderId = ? where itemId = ?;";
    public static final String UPDATE_ALLL_FOLDERS_FOR_GUEST = "UPDATE GuestEmailMetaData SET folderId = ? where folderId = ? AND ownerId = ? AND ownerCid = ?;";
    public static final String DELETE_BY_ID                  = "DELETE FROM GuestEmailMetaData where itemID = ?";
    public static final String DELETE_BY_USER                = "DELETE FROM GuestEmailMetaData where ownerId = ? and ownerCid = ?";
}
