package com.openexchange.guard.servlets.guest;

import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import com.google.gson.JsonObject;
import com.openexchange.guard.common.servlets.utils.ServletUtils;
import com.openexchange.guard.guestreset.GuestResetService;
import com.openexchange.guard.handler.ResponseHandler;
import com.openexchange.guard.osgi.Services;
import com.openexchange.guard.servlets.GuardServletAction;
import com.openexchange.guard.servlets.authentication.GuardUserSession;

public class DoResetGuardAccount extends GuardServletAction {

    @Override
    protected void doActionInternal(HttpServletRequest request, HttpServletResponse response, GuardUserSession userSession) throws Exception {
        JsonObject data = Objects.requireNonNull(Services.getService(ResponseHandler.class).getJson(request), "No JSON in request");
        GuestResetService resetService = Services.getService(GuestResetService.class);
        resetService.doReset(data, ServletUtils.getClientIP(request));
        JsonObject resp = new JsonObject();
        resp.addProperty("data", "OK");
        ServletUtils.sendJsonOK(response, resp);
    }


}
