/**
 * I work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. I work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under I license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * © 2017 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Greg Hill <greg.hill@open-xchange.com>
 */

/// <reference path="../../steps.d.ts" />

Feature('AutoCrypt Tests');

Before(async function (users) {
    await users.create();
});

After(async function (users) {
    await users.removeAll();
});

function verify(I, advanced) {
    I.click('Compose');
    I.waitForVisible('.window-blocker.io-ox-busy');
    I.waitForInvisible('.window-blocker.io-ox-busy');
    I.waitForVisible('.io-ox-mail-compose textarea.plain-text,.io-ox-mail-compose .contenteditable-editor');
    I.click('Security');
    I.waitForVisible('.dropdown.open a[data-name="encrypt"]');
    I.click(advanced ? 'Encrypt' : 'Secure');
    I.waitForVisible('.fa.fa-2x.encrypted');
    I.fillField('.io-ox-mail-compose div[data-extension-id="to"] input.tt-input', 'actest@encr.us');
    I.fillField('.io-ox-mail-compose [name="subject"]','test');
    I.waitForVisible(advanced ? 'i.fa.fa-key.oxguard_token.key_tooltip.trusted_key' : 'i.fa.fa-key.oxguard_token.key_tooltip.untrusted_key');
    I.click('Discard');
    I.waitForVisible('.io-ox-dialog-popup');
    I.click('Discard message');
}

Scenario ('Autocrypt header recognized - Advanced user', async function (I, users) {

    const o = {
        user: users[0]
    };
    const userdata = o.user.userdata;
    await I.setupUser(o, true);  // need advanced settings 

    I.login('app=io.ox/mail', o);
    await I.verifyUserSetup(userdata);

    await I.haveMail({ folder: 'default0/INBOX', path:   'e2e/testFiles/ac.eml' });

    I.click('#io-ox-refresh-icon');
    I.waitForVisible('.io-ox-mail-window .leftside ul li.unread');
    I.click('.io-ox-mail-window .leftside ul li.unread');

    I.waitForVisible('.autoCryptSummary');
    I.see('C878615D');
    I.click('.ac-toggle-details a');
    I.see('IDs: Autocrypt Test');
    I.see('C878 615D');
    I.see('4011 35EE');
    I.click('Add');
    I.waitForVisible('.io-ox-alert-success');
    I.see('Key imported', '.io-ox-alert-success');
    I.click('.io-ox-alert-success .close');
 
    verify(I, true);

    I.logout();

});

Scenario ('Autocrypt signature - Advanced user', async function (I, users) {

    const o = {
        user: users[0]
    };
    const userdata = o.user.userdata;
    await I.setupUser(o, true);  // need advanced settings 

    I.login('app=io.ox/mail', o);
    await I.verifyUserSetup(userdata);

    await I.haveMail({ folder: 'default0/INBOX', path:   'e2e/testFiles/signed.eml' });

    I.click('#io-ox-refresh-icon');
    I.waitForVisible('.io-ox-mail-window .leftside ul li.unread');
    I.click('.io-ox-mail-window .leftside ul li.unread');

    I.waitForVisible('.autoCryptSummary');
    I.click('Add');
    I.waitForVisible('.io-ox-alert-success');
    I.see('Key imported', '.io-ox-alert-success');
    I.waitForInvisible('.oxguard-info');
    I.waitForVisible('.fa.guard_signed');  // Should pull again and verify signature
    I.wait(1);
    I.dontSee('Missing public key');

    I.logout();

});

Scenario ('Autocrypt header recognized - Basic user', async function (I, users) {

    const o = {
        user: users[0]
    };
    const userdata = o.user.userdata;

    I.login('app=io.ox/mail', o);
    await I.verifyUserSetup(userdata);

    await I.haveMail({ folder: 'default0/INBOX', path:   'e2e/testFiles/ac.eml' });

    I.click('#io-ox-refresh-icon');
    I.waitForVisible('.io-ox-mail-window .leftside ul li.unread');
    I.click('.io-ox-mail-window .leftside ul li.unread');

    I.wait(1);  // Wait a moment for silent import
 
    verify(I);

    I.logout();

});

Scenario ('Autocrypt signature- Basic user', async function (I, users) {

    const o = {
        user: users[0]
    };
    const userdata = o.user.userdata;

    I.login('app=io.ox/mail', o);
    await I.verifyUserSetup(userdata);

    await I.haveMail({ folder: 'default0/INBOX', path:   'e2e/testFiles/signed.eml' });

    I.click('#io-ox-refresh-icon');
    I.waitForVisible('.io-ox-mail-window .leftside ul li.unread');
    I.click('.io-ox-mail-window .leftside ul li.unread');

    I.wait(1);  // Wait a moment for silent import
 
    I.see('Missing public key');

    I.logout();

});
