/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * © 2017 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Greg Hill <greg.hill@open-xchange.com>
 */

/// <reference path="../../steps.d.ts" />

Feature('Conversation between users');

Before(async function (users) {
    await users.create();
    await users.create();  // Two users
});

After(async function (users) {
    await users.removeAll();
});

Scenario('Encrypted conversation between two users', async function (I, users) {
    const o1 = {
        user: users[0]
    };
    const o2 = {
        user: users[1]
    };

    await I.setupUser(o1, true);
    await I.setupUser(o2, true);

    const userdata1 = o1.user.userdata;
    const userdata2 = o2.user.userdata;

    I.login('app=io.ox/mail', o1);
    I.waitForVisible('.io-ox-mail-window .window-body .classic-toolbar');

    I.verifyUserSetup(userdata1);  // Verify user has Guard setup
    
    // Test data
    var random = Math.floor((Math.random() * 100000));
    var subject = "Test Subject " + random;
    var data = "Test data " + random;

    // Open compose
    I.sendEmail(userdata2, subject, data);

    I.wait(2);

    // Logout and log back in as second user
    I.logout();
    I.login('app=io.ox/mail', o2);
    I.waitForVisible('.io-ox-mail-window .leftside');
    I.waitForVisible('.io-ox-mail-window .leftside ul li.unread');
    I.click('.io-ox-mail-window .leftside ul li.unread');

    // Change temporary password
    I.changeTemporaryPassword(userdata2);

    I.waitForVisible('.btn[data-action="done"]');  // Wizard shows done
    I.click('.btn[data-action="done"]');

    // Verify decrypted
    I.verifyDecryptedMail(subject, data);

    //Reply
    I.click('Reply');

    I.auth(userdata2);

    I.wait(2);
    // Change contents to ReplyTest to verify later
    within({ frame: '.io-ox-mail-compose-window .editor iframe' }, async () => {
        I.see(data, '.mce-content-body');
        I.see('wrote:');
        I.click('.mce-content-body');
        I.fillField('.mce-content-body', 'ReplyTest');
      });

    I.waitForVisible('i.fa.fa-key.oxguard_token.key_tooltip.trusted_key');
    // Send
    I.click('Send Encrypted');

    I.waitForVisible('.io-ox-mail-window .leftside');
    I.wait(2);
    I.logout();

    //Switch back to first user
    I.login('app=io.ox/mail', o1);
    I.waitForVisible('.io-ox-mail-window .window-body .classic-toolbar');
    I.waitForVisible('.io-ox-mail-window .leftside ul li.unread');
    //Conversation view
    I.click('Sort');
    I.click('Conversations');
    I.wait(1);

    // Read first
    I.click('.io-ox-mail-window .leftside ul li.unread');
    I.waitForElement('.btn.oxguard_passbutton');
    I.waitForElement('input.form-control.password_prompt');
    I.insertCryptPassword('input.form-control.password_prompt', userdata1);
    I.click('.btn.oxguard_passbutton');

    I.verifyDecryptedMail(subject, 'ReplyTest');

    // Check the original is still there in the conversation and decryptable
    I.click('.multiple-messages article:nth-of-type(2) .toggle-mail-body');
    I.waitForElement('input.form-control.password_prompt');
    I.insertCryptPassword('input.form-control.password_prompt', userdata1);
    I.click('.btn.oxguard_passbutton');
    I.wait(1);
    I.switchTo('.multiple-messages article:nth-of-type(2) iframe');
    I.see(data);
    I.switchTo();
    I.wait(1);

    I.logout();

});