define('pgp_mail/key_fetcher', [
    'oxguard/core/og_http',
    'gettext!oxguard'
], function (http, gt) {
    'use strict';

    var checking = [];

    function checkKey(email) {
        if (checking.indexOf(email) > -1) return ($.Deferred().reject());
        checking.push(email);
        return (getKey(email, false));
    }

    function downloadKey(email) {
        return (getKey(email, true));
    }

    // Query Guard server for PGP keys.  Get key if download, else get info on keys
    function getKey(email, download) {
        var def = $.Deferred();
        var params = '&email=' + email +
        '&cid=' + ox.context_id +
        '&userid=' + ox.user_id +
        '&createIfMissing=true' +
        (download === true ? '&download=true' : '');

        http.get(ox.apiRoot + '/oxguard/pgpmail?action=getkey', params)
        .done(function (respData) {
            if (respData !== '') {
                var data;
                if (typeof respData === 'string') {
                    data = JSON.parse(respData).data;
                } else {
                    data = respData.data;
                }
                if (data === 'guest') {
                    def.reject();
                }
                if (data === '') {
                    def.reject();
                }
                def.resolve(data);
                return;
            }
            def.reject();
        })
        .fail(function () {
            def.reject();
        })
        .always(function () {
            // checking.pop(email);
        });
        return (def);
    }

    function promptKeyImport(data, email) {
        var def = $.Deferred();
        require(['io.ox/core/tk/dialogs', 'oxguard/pgp/keyDetails'], function (dialogs, publickeys) {
            var dialog = new dialogs.CreateDialog({ width: 450, height: 450, center: true, enter: 'ok' });
            dialog.header($('<h4>').text(gt('Key found for %1$s.  Import?', email)));
            var keydetail = publickeys.keyDetail(data);
            dialog.getBody().append(keydetail.div);
            dialog.addPrimaryButton('import', gt('Import'), 'import')
            .addButton('cancel', gt('Cancel'), 'cancel')
            .on('import', function () {
                downloadKey(email).done(function (data) {
                    def.resolve(data);
                })
                .fail(function () {
                    def.reject();
                });
            })
            .on('cancel', function () {
                def.reject();
            })
            .show();
        });
        return (def);
    }

    return {
        checkKey: checkKey,
        downloadKey: downloadKey,
        promptKeyImport: promptKeyImport
    };

});
