/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016-2020 OX Software GmbH
 */

define('oxguard/mail/pubkey', ['oxguard/core/og_http',
    'gettext!oxguard'],
function (http, gt) {

    function getPubKeyAttachment() {
        var def = $.Deferred();
        var params = '&keyType=public';
        http.simplePost(ox.apiRoot, '/oxguard/keys?action=downloadKey' + params)
        .done(function (data) {
            if (data === null) {
                def.reject(gt('Unable to get key'));
            }
            if (data.indexOf('BEGIN PGP') > -1) { // Verify PGP structure
                var attach = { // Attach the pgp data as attachment
                    content: data,
                    content_type: 'text/plain',
                    disp: 'attachment',
                    size: data.length,
                    filename: 'public.asc',
                    type: 'asc',
                    group: 'attachment',
                    guard: 'pubkey',
                    raw: true
                };
                def.resolve(attach);
            }
            def.reject();
        })
        .fail(function (data) {
            console.log(data);
            def.reject(gt('Unable to get key'));
        });
        return (def);
    }

    return {
        getPubKeyAttachment: getPubKeyAttachment
    };
});

