/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016-2020 OX Software GmbH
 */
define('oxguard/mail/oxguard_mail_password', [
    'io.ox/core/extensions',
    'oxguard/oxguard_core',
    'oxguard/core/og_http',
    'oxguard/core/passwords',
    'oxguard/core/passwordView',
    'gettext!oxguard',
    'settings!oxguard',
    'less!oxguard/mail/style'
], function (ext, oxguard, http, passwords, PasswordView, gt, guardSettings) {
    'use strict';

    ////////////////////////   RECEIVE / READ

    function loadKeyClick(evt) {
        var file = evt.target.files[0];
        var reader = new FileReader();

        reader.onload = function () {
            //encrPrivKey = event.target.result;
            $('#privKeyButton').html(gt('Loaded'));
        };
        reader.readAsText(file);
    }

    // Unified inbox combines folder and email ID, returns email id
    function getId(baton) {
        var id = decodeURIComponent(baton.data.id);
        try {
            id = id.substring(id.lastIndexOf('/') + 1) + (baton.view.cid ? baton.view.cid : '');
        } catch (e) {
            console.error(e);
        }
        return (id);
    }

    function passwordPrompt(baton, badpass, location, goFunction, localOnly) {
        var id = getId(baton);
        var passwordBoxView = new PasswordView.view({ 'id': 'oxgrpass' + id, 'class': 'password_prompt', 'validate': false });
        var passwordbox = passwordBoxView.getProtected().css('display', 'inline');
        var grdPasswordPrompt = $('<div class="alert og_password"/>');
        //#. %s product Name
        var mainpassprompt = $('<label style="font-weight:bold;" for="oxgrpass' + id + '">' + gt('Secure Email, enter your %s security password.', window.oxguarddata.productName) + '</span><br/><div style="height:10px;"/>');
        if (_.device('small')) {
            passwordbox.css('width', '150px');
        }
        var noSaveWorkAround = $('<input style="display:none" type="text" name="dontremember"/><input style="display:none" type="password" name="dontrememberpass"/>');
        var passButton = $('<button class="btn btn-primary oxguard_passbutton" type="button">' + gt('OK') + '</button><br/>');
        var placeholder = $('<span></span><br/>');
        //#. 'Keep me logged into guard' is followed by dropdown box specifying number of minutes or indefinite, %s product name
        var remembertext = $('<label class="checkbox custom small" for="rememberpass">' + gt('Keep me logged into %s', window.oxguarddata.productName) + '</label>');
        var checkbox = $('<input type="checkbox" id="rememberpass" name="rememberpass' + id + '" value="true" style="margin-top:3px;"/>');
        var rememberpass = $('<div>').append(remembertext.append(checkbox));
        var duration = $('<select id="duration' + id + '" class="og_duration"><option value="10">' + gt('10 minutes') + '</option>' +
                '<option value="20">' + gt('20 minutes') + '</option>' +
                '<option value="30">' + gt('30 minutes') + '</option>' +
                '<option value="60">' + gt('1 hour') + '</option>' +
                '<option value="120">' + gt('2 hours') + '</option>' +
                '<option value="99999">' + gt('Session') + '</option>' +
                '</select>')
                .on('change', function () {
                    $('input[name="rememberpass' + id + '"]').prop('checked', true);
                });
        if (guardSettings.get('defRemember')) {
            duration.val(guardSettings.get('defRemember') === '0' ? 99999 : guardSettings.get('defRemember'));
            if (guardSettings.get('defRemember') !== '0') checkbox.prop('checked', true);
        }
        //#.  Duration is length of time password remembered
        var durationLabel = $('<label>').append(gt('Duration:' + ' '));
        rememberpass.append(durationLabel.append(duration));

        var forgotDiv = $('<div class="og_forgot" style="display:none">');

        if (window.oxguarddata.recoveryAvail) {  // Display password help if available
            var forgotLink = $('<a href="#">').append(gt('Forgot Password'));
            forgotLink.click(function (e) {
                e.preventDefault();
                var options = { id: 'oxguard' };
                ox.launch('io.ox/settings/main', options).done(function () {
                    this.setSettingsPane(options);
                });
            });
            forgotDiv.append(forgotLink);
        }

        var cont = $('<br/><div class="oxguard_error" id = "error' + id + '" style="display:none;"></div>');
        if (window.oxguarddata.passcode === 'NoPrivate') {
            var btn = $('<button class="btn og_getkey" id="privKeyButton' + id + '">' + gt('Select Key Location') + '</button>');

            var input = $('<input type="file" id="files' + id + '" name="files[] style="padding:10px;visibility:hidden;position:absolute;top-50px;left:-50px;"/>');
            btn.click(function () {
                input.click();
            });
            input.change(function (evt) {
                loadKeyClick(evt);
            });
            placeholder.append(btn.after(input));
        }
        passButton.click(function () {
            go();
        });

        grdPasswordPrompt.append(noSaveWorkAround)
            .append(mainpassprompt.append(passwordbox).append(passButton))
            .append(placeholder)
            .append(rememberpass)
            .append(forgotDiv)
            .append(cont);

        grdPasswordPrompt.keydown(function (e) {
            if (e.which === 13) {
                go();
            }
        });

        window.setTimeout(function () {
            passwordbox.removeAttr('readonly');
        }, 500);

        var contdiv = $('<div class="content" id = "content' + id + '"/>').append(grdPasswordPrompt);

        function go() {
            var password = passwordBoxView.getValue();
            if (password === undefined) return;
            var duration = -1;
            if ($('input[name="rememberpass' + id + '"]').is(':checked')) {
                duration = $('#duration' + id).val();
            }
            if (localOnly) {
                goFunction(password, duration);
                return;
            }
            passwordbox.parent().busy();
            passButton.prop('disabled', true);
            oxguard.savePassword(password, duration)
            .done(function () {
                goFunction(password);
            })
            .fail(function (data) {
                $('#busygif').hide();
                passwordbox.parent().idle();
                passButton.prop('disabled', false);
                require(['io.ox/core/notifications'], function (notifications) {
                    if (data.auth && data.auth.indexOf('Lockout') > -1) {
                        notifications.yell('error', gt('Temporary Lockout'));
                    } else {
                        notifications.yell('error', gt('Bad password'));
                        if (window.oxguarddata.recoveryAvail) $('.og_forgot').show();
                    }
                });
            });
        }
        return (contdiv);
    }

    return {
        passwordPrompt: passwordPrompt,
        getId: getId
    };
});
