/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016-2020 OX Software GmbH
 */
define('oxguard/mail/guestPrompt', [
    'io.ox/core/tk/dialogs',
    'oxguard/mail/mail_metrics',
    'gettext!oxguard',
    'less!oxguard/mail/style'
], function (dialogs, metrics, gt) {

    // Display options for guest account header (introduction)
    function guestOptions(baton) {

        var def = $.Deferred();
        var dialog = new dialogs.CreateDialog({ width: 490, center: true, enter: 'ok' });
        dialog.header($('<h4>').text(gt('Recipient Options')));
        var help = $('<p>' + gt('At least one of your recipients uses a different webmail system.  They will receive an email with a link for them to read this message.  If you like, you can add a personalized message that will appear at the top of this message.  This will help identify the message as coming from you.') + '</p>');
        var messageLabel = $('<label class="oxguard_message_label">' + gt('Message:') + '</label>');
        var message = $('<textarea type="text" id="message" class="og_guest_message"></textarea>');
        var languageLabel = $('<br/><label style="width:100%; padding-top:10px;">' + gt('Language for recipient Email') + '</label>');
        var langselect = $('<select class="og_language"></select>');
        var warning = $('<p class="oxguard_warn" style="margin-top:10px;">').append(gt('Note: Emails sent to mailing lists or groups will not work.'));
        // Populate language selector with languages avail
        var languages = window.oxguarddata.lang;
        $.each(languages, function (c, n) {
            langselect.append('<option value="' + c + '">' + n + '</option>');
        });
        dialog.getBody().append(help).append(messageLabel).append(message).append(languageLabel.append(langselect)).append(warning);
        dialog.addPrimaryButton('ok', gt('OK'), 'ok')
        .addButton('cancel', gt('Cancel'), 'cancel')
        .on('ok', function () {
            var data = {
                message: message.val(),
                language: langselect.val()
            };
            if (message.val() && message.val().length > 1) {
                metrics.track('guest-email-message');
            } else {
                metrics.track('guest-email-no-message');
            }
            // Check if requires PIN to be displayed
            require(['oxguard/mail/pin', 'io.ox/core/capabilities'], function (pin, capabilities) {
                if (capabilities.has('guard-pin')) {
                    pin.showpin(baton)
                    .done(function (e) {
                        data.pin = e;
                        def.resolve(data);
                    })
                    .fail(function () {
                        def.resolve(data);
                    });
                } else def.resolve(data);
            });
        })
        .on('cancel', function () {
            baton.view.app.getWindow().idle();
        });
        dialog.show(function () {
            var urlLang = ox.language;
            if ($('.og_language option[value="' + urlLang + '"]').length > 0) {
                langselect.val(urlLang);
            } else {
                langselect.val(urlLang.substring(0, 2));
            }
        });
        return def;
    }

    return {
        guestOptions: guestOptions
    };

});
