/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016-2020 OX Software GmbH
 */
define('oxguard/contacts/register_contacts', [
    'io.ox/core/extensions',
    'oxguard/pgp/keyDetails',
    'settings!oxguard',
    'gettext!oxguard',
    'less!oxguard/style',
    'less!oxguard/contacts/style'
], function (ext, pubkeys, settings, gt) {

    ext.point('io.ox/contacts/detail/content').extend({
        id: 'pgppublic',
        index: 'last',
        draw: function (baton) {
            //FIXME: this completely disables the point for apps other than settings and contacts (like mail called from sidepanel)
            if (!(baton.app && baton.app.cid)) return;
            if (!settings.get('advanced')) return;  //advanced view only
            if (baton.data && baton.data.distribution_list) return;  // Not listing for distribution lists

            var newfield = $('<dl class="dl-horizontal">');
            var legend = $('<dt>').append(gt('PGP Keys'));
            var data = pubkeys.listPublic({
                id: baton.app.cid,
                folder_id: baton.data.folder_id,
                contact_id: baton.data.id,
                header: false
            });
            this.append($('<section class="block contactKeys' + baton.app.cid + '" style="display:none">').append(newfield.append(legend).append($('<dd>').append(data))));


        }
    });
});
