/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.servlets.pgpmail;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import com.openexchange.exception.OXException;
import com.openexchange.guard.servlets.AbstractGuardServlet;
import com.openexchange.guard.servlets.GuardErrorResponseRenderer;
import com.openexchange.guard.servlets.GuardServletAction;
import com.openexchange.guard.servlets.authentication.BasicAuthServletAuthenticationHandler;
import com.openexchange.guard.servlets.authentication.OXGuardSessionAuthenticationHandler;

/**
 * Provides PGP mailing functionality
 *
 * @author <a href="mailto:benjamin.gruedelbach@open-xchange.com">Benjamin Gruedelbach</a>
 * @since v2.4.0
 */
public class PGPMailServlet extends AbstractGuardServlet {

    private static final long serialVersionUID = -3402143663178340210L;
    private static final String GET_PUBLIC_KEY_FROM_ATTACHMENT_ACTION = "savepublicattach";

    private static final String POST_PROCESS_INCOMING_MIME = "process_mime";
    private static final String POST_VERIFY_MESSAGE = "verify";
    private static final String POST_DECRYPT_MIME_MESSAGE = "decrypt";

    private transient final HashMap<String, GuardServletAction> getActions;
    private transient final HashMap<String, GuardServletAction> postActions;

    /**
     * Initializes a new {@link PGPMailServlet}.
     * @throws OXException
     */
    public PGPMailServlet() throws OXException {

        OXGuardSessionAuthenticationHandler userSessionAuthenticationHandler = new OXGuardSessionAuthenticationHandler();
        BasicAuthServletAuthenticationHandler basicAuthAuthenticationHandler = createBasicAuthHandler();

        //GET
        getActions = new HashMap<String, GuardServletAction>();
        getActions.put(GET_PUBLIC_KEY_FROM_ATTACHMENT_ACTION, new GetPublicKeyFromAttachmentAction().setAuthenticationHandler(userSessionAuthenticationHandler));

        //POST
        postActions = new HashMap<String, GuardServletAction>();
        postActions.put(POST_PROCESS_INCOMING_MIME,
            new MimeEmailAction()
                .setAuthenticationHandler(basicAuthAuthenticationHandler)
                .setErrorResponseRenderer(new GuardErrorResponseRenderer(HttpServletResponse.SC_INTERNAL_SERVER_ERROR)));
        postActions.put(POST_DECRYPT_MIME_MESSAGE,
            new DecryptMimeEmailAction()
                .setAuthenticationHandler(basicAuthAuthenticationHandler)
                .setErrorResponseRenderer(new GuardErrorResponseRenderer(HttpServletResponse.SC_INTERNAL_SERVER_ERROR)));
        postActions.put(POST_VERIFY_MESSAGE,
            new VerifyMimeEmailAction()
                .setAuthenticationHandler(basicAuthAuthenticationHandler)
                .setErrorResponseRenderer(new GuardErrorResponseRenderer(HttpServletResponse.SC_INTERNAL_SERVER_ERROR)));
    }


    /* (non-Javadoc)
     * @see javax.servlet.http.HttpServlet#doGet(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
     */
    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        doAction(request, response, getActions);
    }

    /* (non-Javadoc)
     * @see javax.servlet.http.HttpServlet#doPost(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
     */
    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        doAction(request,response,postActions);
    }
}
