/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.milter.internal;


/**
 * {@link MilterConstants}
 *
 * Constants taken from http://cpansearch.perl.org/src/AVAR/Sendmail-PMilter-0.98/doc/milter-protocol.txt
 * @author <a href="mailto:greg.hill@open-xchange.com">Greg Hill</a>
 * @since v2.8.0
 */
public class MilterConstants {

    public static final int COMMAND_CONNECT = 'C';
    public static final int COMMAND_MACRO = 'D';
    public static final int COMMAND_HELO = 'H';
    public static final int COMMAND_MAIL = 'M';
    public static final int COMMAND_RCPT = 'R';
    public static final int COMMAND_BODYEOB = 'E';
    public static final int COMMAND_HEADER = 'L';
    public static final int COMMAND_EOH = 'N';
    public static final int COMMAND_OPTNEG = 'O';
    public static final int COMMAND_QUIT = 'Q';
    public static final int COMMAND_BODY = 'B';
    public static final int COMMAND_ABORT = 'A';

    public static final int RESPONSE_ACCEPT = 'a';
    public static final int RESPONSE_ADDHEADER = 'h';
    public static final int RESPONSE_ADDRCPT = '+';
    public static final int RESPONSE_CHGHEADER = 'm';
    public static final int RESPONSE_CONTINUE = 'c';
    public static final int RESPONSE_DELRCPT = '-';
    public static final int RESPONSE_DISCARD = 'd';
    public static final int RESPONSE_QUARENTINE = 'q';
    public static final int RESPONSE_PROGRESS = 'p';
    public static final int RESPONSE_REJECT = 'r';
    public static final int RESPONSE_REPLBODY = 'b';
    public static final int RESPONSE_REPLYCODE = 'y';
    public static final int RESPONSE_TEMPFAIL = 't';

    public static final int PROCESS_NOCOMMAND = 0x0001;
    public static final int PROCESS_NOHELO = 0x0002;
    public static final int PROCESS_NOMAIL = 0x0004;
    public static final int PROCESS_NORCPT = 0x0008;
    public static final int PROCESS_NOBODY = 0x0010;
    public static final int PROCESS_NOHDRS = 0x0020;
    public static final int PROCESS_NOEOH = 0x0040;

    public static final int SMFIA_INET = '4';
    public static final int SMFIA_INET6 = '6';

}
