/*
 * Decompiled with CFR 0.152.
 */
package com.j256.simplemagic.logger;

import com.j256.simplemagic.logger.Log;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slf4jLoggingLog
implements Log {
    private final Logger logger;

    public Slf4jLoggingLog(String className) {
        this.logger = LoggerFactory.getLogger((String)className);
    }

    @Override
    public boolean isLevelEnabled(Log.Level level) {
        switch (level) {
            case TRACE: {
                return this.logger.isTraceEnabled();
            }
            case DEBUG: {
                return this.logger.isDebugEnabled();
            }
            case INFO: {
                return this.logger.isInfoEnabled();
            }
            case WARNING: {
                return this.logger.isWarnEnabled();
            }
            case ERROR: {
                return this.logger.isErrorEnabled();
            }
            case FATAL: {
                return this.logger.isErrorEnabled();
            }
        }
        return this.logger.isInfoEnabled();
    }

    @Override
    public void log(Log.Level level, String msg) {
        switch (level) {
            case TRACE: {
                this.logger.trace(msg);
                break;
            }
            case DEBUG: {
                this.logger.debug(msg);
                break;
            }
            case INFO: {
                this.logger.info(msg);
                break;
            }
            case WARNING: {
                this.logger.warn(msg);
                break;
            }
            case ERROR: {
                this.logger.error(msg);
                break;
            }
            case FATAL: {
                this.logger.error(msg);
                break;
            }
            default: {
                this.logger.info(msg);
            }
        }
    }

    @Override
    public void log(Log.Level level, String msg, Throwable t) {
        switch (level) {
            case TRACE: {
                this.logger.trace(msg, t);
                break;
            }
            case DEBUG: {
                this.logger.debug(msg, t);
                break;
            }
            case INFO: {
                this.logger.info(msg, t);
                break;
            }
            case WARNING: {
                this.logger.warn(msg, t);
                break;
            }
            case ERROR: {
                this.logger.error(msg, t);
                break;
            }
            case FATAL: {
                this.logger.error(msg, t);
                break;
            }
            default: {
                this.logger.info(msg, t);
            }
        }
    }
}

