/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.servlets.authentication;

import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.openexchange.guard.common.servlets.utils.ServletUtils;
import com.openexchange.guard.servlets.GuardServletAction;

/**
 * Checks for a valid OX Guard session (either UI or Guard Guest session) within a OX Guard request
 *
 * @author <a href="mailto:benjamin.gruedelbach@open-xchange.com">Benjamin Gruedelbach</a>
 * @since v2.4.0
 */
public class OXGuardSessionAuthenticationHandler implements GuardAuthenticationHandler {

    private static final String WWW_AUTHENTICATE_GUARD_SESSION = "Valid OX Guard session";
    private static Logger logger = LoggerFactory.getLogger(OXGuardSessionAuthenticationHandler.class);

    /**
     * checks if the request is related to a valid OX UI session or an OX Guard guest session
     * @param request the request
     * @return true, if the request is related to a valid Guard session, false otherwise
     */
    private boolean authenticateInternal(GuardServletAction action, GuardUserSession userSession, HttpServletRequest request) {
        return userSession != null;
    }

    @Override
    public boolean authenticate(GuardServletAction action, GuardUserSession userSession, HttpServletRequest request) throws Exception {
        if(!authenticateInternal(action, userSession, request)) {
            logger.error(String.format("No valid Guard session for IP %s for request %s.",
                                       ServletUtils.getClientIP(request),
                                       request.toString()));
            return false;
        }
        return true;
    }

    @Override
    public String getWWWAuthenticateHeader() {
        return WWW_AUTHENTICATE_GUARD_SESSION;
    }
}
