/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.pgp.exceptions;

import com.openexchange.i18n.LocalizableStrings;

/**
 * {@link GuardPGPExceptionMessages}
 *
 * @author <a href="mailto:martin.schneider@open-xchange.com">Martin Schneider</a>
 * @since v2.4.0
 */
public class GuardPGPExceptionMessages implements LocalizableStrings {

    // Unable to obtain the PGP keys for the sender
    public static final String SENDER_KEYS_MISSING_MSG = "Unable to retrieve sender keys.";

    // Failed to send the email followed by the reason
    public static final String SEND_FAILED_MSG = "Sending email failed: %1$s";

    // An encoding error.  This is a technical error
    public static final String ENCODING_NOT_SUPPORTED_MSG = "The provided encoding is not supported.";

    // An error occured when createing the encrypted email
    public static final String MAIL_CONSTRUCTION_ERROR_MSG = "Error while creating the encrypted email.";

    /** Returned when provided password for decoding a file was wrong */
    public static final String BAD_PASSWORD_ERROR_MSG = "The provided password seems to be wrong or something bad happened.";

    // A generic error message followed by reason
    public static final String IO_ERROR_MSG  = "An I/O error occurred: %1$s";

    // Signature found, but the data it was signing wasn't found
    public static final String SIGNATURE_ERROR_NO_SIGNED_DATA_MSG  = "No signed data found in email";

    // Unable to find a signature in the email
    public static final String SIGNATURE_ERROR_NO_SIGNATURE_MSG  = "No signature found in email";

    // No signed message found in this PGP Inline type email
    public static final String SIGNATURE_ERROR_NO_SIGNED_MESSAGE_FOUND_MSG  = "No signed message found in inline email";

    // Mail formatting error.  Mime is type of email formatting.  Mulipart is sub-type of the format
    public static final String MIME_NOT_MULTIPART_ERROR_MSG  = "The Mime message's content is not a MultiPart content";

    // Mail does not contain encrypted part
    public static final String MIME_NO_GUARDPART_ERROR_MSG  = "The MIME message does not contain an OX Guard part";

    // The attachment couldn't be found with the name specified
    public static final String MIME_ATTACHMENT_NOT_FOUND_MSG = "No attachment found in MIME with name %1$s";

    // The attachment couldn't be found with the id specified
    public static final String MIME_ATTACHMENT_ID_NOT_FOUND_MSG  = "No attachment found in MIME with id %1$s";

    // Unexpected error followed by the error message
    public static final String UNEXPECTED_ERROR_MSG  = "An error occurred: %1$s";

    // Unable to decode the pgp key for the specified user in the specified context
    public static final String UNABLE_TO_DECODE_MSG  = "Unable to decode pgp key for user %1$s in context %2$s.";

    // Unable to find the key with specified id
    public static final String KEY_NOT_FOUND_MSG  = "Key with id %1$s not found";

    // No valid public keys were found
    public static final String NO_VALID_KEY_MSG  = "There were no valid public keys found.  Either the keys are expired or they are not flagged for this action.";

    public static final String NO_VALID_PUBLIC_KEYS_FOUND_MSG = "There were no valid public keys found.  Either the keys are expired or they are not flagged for this action.";

    private GuardPGPExceptionMessages() {
        super();
    }
}
