/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.wks.osgi;

import org.osgi.service.http.HttpService;
import com.openexchange.exception.OXException;
import com.openexchange.guard.configuration.GuardConfigurationService;
import com.openexchange.guard.database.GuardDatabaseService;
import com.openexchange.guard.email.storage.ogEmail.EmailStorage;
import com.openexchange.guard.keymanagement.services.AccountCreationService;
import com.openexchange.guard.keymanagement.services.GuardKeyService;
import com.openexchange.guard.keymanagement.services.RecipKeyService;
import com.openexchange.guard.keymanagement.storage.KeyTableStorage;
import com.openexchange.guard.keys.PGPKeyService;
import com.openexchange.guard.ratifier.GuardRatifierService;
import com.openexchange.guard.wks.internal.WksSetup;
import com.openexchange.guard.wks.servlets.WksServlet;
import com.openexchange.osgi.HousekeepingActivator;

/**
 * {@link WksActivator}
 *
 * @author <a href="mailto:greg.hill@open-xchange.com">Greg Hill</a>
 * @since 2.10.0
 */
public class WksActivator extends HousekeepingActivator {

    private static final String GUARD_HU_SERVLET_PATH = "/hu";

    /**
     * {@inheritDoc}
     */
    @Override
    protected Class<?>[] getNeededServices() {
        return new Class<?>[] { HttpService.class, GuardConfigurationService.class, EmailStorage.class,
            KeyTableStorage.class, GuardDatabaseService.class};
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected void startBundle() throws Exception {
        org.slf4j.LoggerFactory.getLogger(WksActivator.class).info("Starting bundle: {}", context.getBundle().getSymbolicName());

        Services.setServiceLookup(this);

        getService(HttpService.class).registerServlet(GUARD_HU_SERVLET_PATH, new WksServlet(), null, null);
        checkAvailable();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected void stopBundle() throws Exception {
        org.slf4j.LoggerFactory.getLogger(WksActivator.class).info("Stopping bundle: {}", this.context.getBundle().getSymbolicName());

        HttpService httpService = getService(HttpService.class);
        if (httpService != null) {
            httpService.unregister(GUARD_HU_SERVLET_PATH);
        }

        Services.setServiceLookup(null);

        super.stopBundle();
    }

    /**
     * Check if the user hash tables have been set up and are available.
     * If not, calls setup
     * @throws OXException
     */
    private void checkAvailable() throws OXException {
        EmailStorage storage = Services.getService(EmailStorage.class);
        if (storage.getCount() == 0) return;  // No keys
        if (storage.getMissingHuCount() == 0) return;  // Fully populated, return
        WksSetup.doUpgradeHu(); // Otherwise, we need to do upgrade
    }
}
