/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.mime.helpfiles;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.mail.BodyPart;
import com.openexchange.exception.OXException;
import com.openexchange.guard.keymanagement.commons.RecipKey;

/**
 * {@link HelpFileService} offers functionality to create plain text help attachments.
 * <br>
 * <br>
 * An additional help file is a plain text attachment which contains useful information for the end-user about how to decrypt an E-Mail.
 * This is can be displayed by clients if no functionality is available/installed to decrypt the pgp part of the message.
 *
 * @author <a href="mailto:benjamin.gruedelbach@open-xchange.com">Benjamin Gruedelbach</a>
 * @since v7.10.0
 */
public interface HelpFileService {

    /**
     * Gets the help attachments as instances of {@link BodyPart} for the given languages.
     *
     * @param languages The languages to get the help attachments for.
     * @return A collection of help attachments
     * @throws OXException
     */
    public List<BodyPart> getHelpFiles(String... languages) throws OXException;

    /**
     * Gets the help attachments as instances of {@link BodyPart} for the given locales.
     *
     * @param locales The locales to get the help attachments for.
     * @return A collection of help attachments for the given locales
     * @throws OXException
     */
    public List<BodyPart> getHelpFiles(Locale... locales) throws OXException;

    /**
     * Gets a list of help files for a list of recipients if configured
     * @param recips
     * @return
     * @throws OXException
     */
    public List<BodyPart> getHelpFiles(ArrayList<RecipKey> recips) throws OXException;
}
