/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.guestupgrade.exceptions;

import com.openexchange.i18n.LocalizableStrings;

/**
 * {@link GuardGuestUpgraderExceptionMessages}
 *;
 * @author <a href="mailto:benjamin.gruedelbach@open-xchange.com">Benjamin Gruedelbach</a>
 * @since v7.10.0
 */
public class GuardGuestUpgraderExceptionMessages implements LocalizableStrings {

    // Unable to find guest account with specified email
    public static final String UNKNOWN_GUEST_ACCOUNT_MSG = "Unable to find guest account for email '%1$s'.";
    // The user specified by the email address is already upgraded
    public static final String ALREADY_UPGRADED_MSG = "Already upgraded user with email '%1$s'.";
    // No OX account exists with the specified email address
    public static final String UNKNOWN_OX_ACCOUNT_MSG = "No OX account with email '%1$s'.";
    // Error upgrading account specified by email %1, error message %2
    public static final String UPGRADE_ERROR_MSG = "Error upgrading account for email '%1$s': '%2$s'.";
    // Unable to upgrade the account specified by email %1 as this email resolves to a guest account
    public static final String GUEST_ACCOUNT_MSG = "Unable to upgrade by email address, email '%1$s' resolves to a guest account";

    private GuardGuestUpgraderExceptionMessages() { }
}
