/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.guest.osgi;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.openexchange.caching.CacheService;
import com.openexchange.guard.activity.ActivityTrackingService;
import com.openexchange.guard.caching.GenericCacheFactory;
import com.openexchange.guard.configuration.GuardConfigurationService;
import com.openexchange.guard.configuration.GuardProperty;
import com.openexchange.guard.database.GuardDatabaseService;
import com.openexchange.guard.email.storage.ogEmail.EmailStorage;
import com.openexchange.guard.encryption.EncryptedItemsStorage;
import com.openexchange.guard.guest.GuardGuestService;
import com.openexchange.guard.guest.GuestConverterService;
import com.openexchange.guard.guest.GuestLookupService;
import com.openexchange.guard.guest.impl.CachingGuestLookupService;
import com.openexchange.guard.guest.impl.GuardGuestServiceImpl;
import com.openexchange.guard.guest.impl.GuestConverterServiceImpl;
import com.openexchange.guard.guest.impl.GuestLookupServiceImpl;
import com.openexchange.guard.guest.impl.converters.BlobToMimeConverter;
import com.openexchange.guard.guest.impl.converters.GuestItemConverter;
import com.openexchange.guard.guest.impl.converters.MetaDataConverter;
import com.openexchange.guard.guest.metadata.storage.CachingGuardGuestEMailMetadataService;
import com.openexchange.guard.guest.metadata.storage.GuardGuestEMailMetadataService;
import com.openexchange.guard.guest.redirector.GuestRedirectorService;
import com.openexchange.guard.guest.redirector.GuestRedirectorServiceImpl;
import com.openexchange.guard.guestupgrade.storage.GuestUpgradeStorageService;
import com.openexchange.guard.keymanagement.services.GuardKeyService;
import com.openexchange.guard.mime.helpfiles.HelpFileService;
import com.openexchange.guard.pgpcore.services.PGPMimeCryptoService;
import com.openexchange.guard.pgpcore.services.impl.DBKeyRetrievalStrategy;
import com.openexchange.guard.storage.Storage;
import com.openexchange.guard.storage.cache.CachingFileCacheStorage;
import com.openexchange.guard.storage.cache.FileCacheStorage;
import com.openexchange.osgi.HousekeepingActivator;
import com.openexchange.pgp.mail.PGPMimeService;

/**
 * {@link GuestActivator}
 *
 * @author <a href="mailto:benjamin.gruedelbach@open-xchange.com">Benjamin Gruedelbach</a>
 * @since v7.10.0
 */
public class GuestActivator extends HousekeepingActivator {

    private final static Logger logger = LoggerFactory.getLogger(GuestActivator.class);

    /* (non-Javadoc)
     * @see com.openexchange.osgi.DeferredActivator#getNeededServices()
     */
    @Override
    protected Class<?>[] getNeededServices() {
        return new Class[] { PGPMimeCryptoService.class, Storage.class, FileCacheStorage.class, PGPMimeService.class,
                             GuardKeyService.class, GuardConfigurationService.class, GuardGuestEMailMetadataService.class,
                             HelpFileService.class, EncryptedItemsStorage.class, GuardDatabaseService.class,
                             EmailStorage.class, GenericCacheFactory.class, GuestUpgradeStorageService.class };

    }

    @Override
    protected Class<?>[] getOptionalServices() {
        return new Class[] { CacheService.class, ActivityTrackingService.class };
    }

    /* (non-Javadoc)
     * @see com.openexchange.osgi.DeferredActivator#startBundle()
     */
    @Override
    protected void startBundle() throws Exception {
        logger.info("Starting bundle {}", context.getBundle().getSymbolicName());

        GuestItemConverter[] guestItemConverters = new GuestItemConverter[]{
            new BlobToMimeConverter(
                getService(PGPMimeService.class),
                new DBKeyRetrievalStrategy(getService(GuardKeyService.class)),
                getService(HelpFileService.class),
                getService(GuardConfigurationService.class)),
            new MetaDataConverter(
                getService(GuardGuestEMailMetadataService.class))
        };

        GuardGuestEMailMetadataService guestEMailMetadataService = getService(GuardGuestEMailMetadataService.class);
        FileCacheStorage fileCacheStorage = getService(FileCacheStorage.class);
        GuestLookupService guestLookupService = new GuestLookupServiceImpl(
            getService(EmailStorage.class));
        final boolean caching = getService(GuardConfigurationService.class).getBooleanProperty(GuardProperty.guestCaching);
        if(caching) {
            //Setup caching
            guestEMailMetadataService  = new CachingGuardGuestEMailMetadataService(getService(GenericCacheFactory.class), guestEMailMetadataService);
            fileCacheStorage = new CachingFileCacheStorage(getService(GenericCacheFactory.class),fileCacheStorage);
            guestLookupService = new CachingGuestLookupService(getService(GenericCacheFactory.class), guestLookupService, getService(EmailStorage.class));
        }

        registerService(GuardGuestService.class, new GuardGuestServiceImpl(
            getService(PGPMimeCryptoService.class),
            getService(Storage.class),
            fileCacheStorage,
            getService(GuardConfigurationService.class),
            guestEMailMetadataService,
            getOptionalService(ActivityTrackingService.class),
            getService(GuestUpgradeStorageService.class)));

        GuestRedirectorService redirector = new GuestRedirectorServiceImpl(getService(GuardDatabaseService.class));
        registerService(GuestRedirectorService.class, redirector);

        registerService(GuestConverterService.class, new GuestConverterServiceImpl(
            getService(EncryptedItemsStorage.class),
            redirector,
            getService(Storage.class),
            getService(GuardGuestEMailMetadataService.class),
            getService(FileCacheStorage.class),
            guestItemConverters));

        registerService(GuestLookupService.class, guestLookupService);

    }

    /* (non-Javadoc)
     * @see com.openexchange.osgi.HousekeepingActivator#stopBundle()
     */
    @Override
    protected void stopBundle() throws Exception {
        logger.info("Stopping bundle {}", context.getBundle().getSymbolicName());
        unregisterService(GuardGuestService.class);
        super.stopBundle();
    }

}
